/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.model.matchlets.support;

import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;

public enum MatchingSerializationExclusionPolicy {
    ALWAYS(0),
    NEVER(1),
    NON_PERFORMED(2),
    AUTHORITATIVE(3),
    NO_MATCH(4),
    AUTHORITATIVE_NO_MATCH(5),
    MATCH(6),
    FULL_MATCH(7),
    AUTHORITATIVE_FULL_MATCH(8);

    int _when;

    private MatchingSerializationExclusionPolicy(int when) {
        this._when = when;
    }

    public int getWhen() {
        return this._when;
    }

    public boolean shouldExclude(MatchingScore score) {
        AssertionUtils.$nNull(score, "Score cannot be null", new Object[0]);
        if (this == ALWAYS) {
            return true;
        }
        if (this == NEVER) {
            return false;
        }
        switch (this) {
            case NON_PERFORMED: {
                return score.isNonPerformed();
            }
            case AUTHORITATIVE: {
                return score.isAuthoritative();
            }
            case NO_MATCH: 
            case AUTHORITATIVE_NO_MATCH: {
                return score.isNoMatch();
            }
            case MATCH: {
                return !score.isNoMatch();
            }
            case FULL_MATCH: {
                return score.isFullMatch();
            }
            case AUTHORITATIVE_FULL_MATCH: {
                return score.isAuthoritative() && score.isFullMatch();
            }
        }
        return false;
    }
}

