/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.patterns.handlers.id.impl.basic;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.fao.fi.comet.core.model.common.annotations.Identifier;
import org.fao.fi.comet.core.patterns.handlers.id.exceptions.IdentifierException;
import org.fao.fi.comet.core.patterns.handlers.id.exceptions.MultipleIdentifierAnnotationsException;
import org.fao.fi.comet.core.patterns.handlers.id.exceptions.NoIdentifierAnnotationsException;
import org.fao.fi.comet.core.patterns.handlers.id.impl.IDHandlerSkeleton;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.classes.ClassUtils;

public class AnnotationDrivenDataIDHandler<DATA>
extends IDHandlerSkeleton<DATA, Serializable> {
    @Override
    protected final Serializable doGetId(DATA data) {
        AssertionUtils.$nNull(data, "Data cannot be NULL", new Object[0]);
        this.checkAnnotations(data);
        Field[] annotatedFields = this.getAnnotatedFields(data);
        try {
            HashMap classesToFieldMap = new HashMap();
            Field[] fieldArray = annotatedFields;
            int n = annotatedFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Class<?> fieldClass = field.getDeclaringClass();
                if (!classesToFieldMap.containsKey(fieldClass)) {
                    classesToFieldMap.put(fieldClass, new HashSet());
                }
                ((Set)classesToFieldMap.get(fieldClass)).add(field);
                ++n2;
            }
            if (annotatedFields != null && annotatedFields.length > 0) {
                for (Class clazz : classesToFieldMap.keySet()) {
                    if (((Set)classesToFieldMap.get(clazz)).size() <= 1) continue;
                    throw new MultipleIdentifierAnnotationsException("Multiple 'identifier' annotations found on fields of class " + clazz);
                }
                return this.getId(data, annotatedFields[0]);
            }
            return this.getId(data, this.getAnnotatedMethods(data)[0]);
        }
        catch (IdentifierException Ie) {
            throw Ie;
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to retrieve ID by annotation on " + data);
        }
    }

    private Serializable getId(DATA object, Field field) throws Throwable {
        return (Serializable)field.get(object);
    }

    private Serializable getId(DATA object, Method method) throws Throwable {
        return (Serializable)method.invoke(object, new Object[0]);
    }

    private void checkAnnotations(DATA object) {
        if (object == null) {
            throw new NullPointerException("Object cannot be null");
        }
        Field[] annotatedFields = this.getAnnotatedFields(object);
        Method[] annotatedMethods = this.getAnnotatedMethods(object);
        int numAnnotatedFields = annotatedFields.length;
        int numAnnotatedMethods = annotatedMethods.length;
        if (numAnnotatedFields == 0 && numAnnotatedMethods == 0) {
            throw new NoIdentifierAnnotationsException("No @" + Identifier.class.getSimpleName() + " annotations found for fields of type (or getter methods returning an instance of) java.lang.Serializable for object of class " + object.getClass().getSimpleName() + ".");
        }
    }

    private Field[] getAnnotatedFields(DATA object) {
        if (object == null) {
            return null;
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : ClassUtils.listAllFields(object.getClass())) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(Identifier.class) || !Serializable.class.isAssignableFrom(field.getType())) continue;
            fields.add(field);
        }
        return fields.toArray(new Field[fields.size()]);
    }

    private Method[] getAnnotatedMethods(DATA object) {
        if (object == null) {
            return null;
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : ClassUtils.getAllGetterMethods(object.getClass(), Serializable.class)) {
            method.setAccessible(true);
            if (!method.isAnnotationPresent(Identifier.class)) continue;
            methods.add(method);
        }
        return methods.toArray(new Method[methods.size()]);
    }
}

