/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.patterns.handlers.id.impl.basic;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.fao.fi.comet.core.patterns.handlers.id.exceptions.MultipleNamedIdentifiersException;
import org.fao.fi.comet.core.patterns.handlers.id.exceptions.NoNamedIdentifierException;
import org.fao.fi.comet.core.patterns.handlers.id.impl.IDHandlerSkeleton;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.classes.ClassUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;

public class NameDrivenDataIDHandler<DATA extends Serializable>
extends IDHandlerSkeleton<DATA, Serializable> {
    private final String _IDName;

    public NameDrivenDataIDHandler(String IDName) {
        if (IDName == null) {
            throw new UnsupportedOperationException("ID name cannot be null");
        }
        this._IDName = IDName;
    }

    @Override
    protected final Serializable doGetId(DATA data) {
        AssertionUtils.$nNull(data, "Data cannot be NULL", new Object[0]);
        this.checkNames(data, this._IDName);
        Field[] annotatedFields = this.getNamedFields(data, this._IDName);
        try {
            if (annotatedFields.length == 1) {
                return this.getId(data, annotatedFields[0]);
            }
            return this.getId(data, this.getNamedMethods(data, this._IDName)[0]);
        }
        catch (Throwable t) {
            throw new NoNamedIdentifierException("Unable to retrieve ID by name " + this._IDName + " on " + data);
        }
    }

    private Serializable getId(DATA object, Field field) throws Throwable {
        return (Serializable)field.get(object);
    }

    private Serializable getId(DATA object, Method method) throws Throwable {
        return (Serializable)method.invoke(object, new Object[0]);
    }

    private void checkNames(DATA object, String IDName) {
        Method[] namedMethods;
        int numNamedMethods;
        Field[] namedFields = this.getNamedFields(object, IDName);
        int numNamedFields = namedFields.length;
        if (numNamedFields + (numNamedMethods = (namedMethods = this.getNamedMethods(object, IDName)).length) > 1) {
            throw new MultipleNamedIdentifiersException("Multiple fields or getter methods referring to name '" + IDName + "' found for object of class " + object.getClass().getSimpleName() + ". Currently: " + numNamedFields + " annotated fields and " + numNamedMethods + " annotated getter methods");
        }
        if (numNamedFields == 0 && numNamedMethods == 0) {
            throw new NoNamedIdentifierException("No fields of type (or getter methods returning an instance of) java.lang.Serializable and named after '" + IDName + "' found for object of class " + object.getClass().getSimpleName() + ".");
        }
    }

    private Field[] getNamedFields(DATA object, String IDName) {
        if (object == null) {
            return null;
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : ClassUtils.listAllFields(object.getClass())) {
            field.setAccessible(true);
            if (!IDName.equals(field.getName())) continue;
            fields.add(field);
        }
        return fields.toArray(new Field[fields.size()]);
    }

    private Method[] getNamedMethods(DATA object, String IDName) {
        if (object == null) {
            return null;
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : ClassUtils.getAllGetterMethods(object.getClass(), Serializable.class)) {
            method.setAccessible(true);
            if (!method.getName().equals("get" + StringUtils.capitalizeFirstLetter(IDName))) continue;
            methods.add(method);
        }
        return methods.toArray(new Method[methods.size()]);
    }
}

