/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.uniform.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;
import org.fao.fi.comet.core.engine.MatchingEngineCore;
import org.fao.fi.comet.core.engine.process.handlers.MatchingProcessHandler;
import org.fao.fi.comet.core.exceptions.MatchingProcessException;
import org.fao.fi.comet.core.exceptions.MatchletConfigurationException;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.engine.Matching;
import org.fao.fi.comet.core.model.engine.MatchingDetails;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessConfiguration;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessResult;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessorInfo;
import org.fao.fi.comet.core.model.engine.MatchingResult;
import org.fao.fi.comet.core.model.engine.MatchingsData;
import org.fao.fi.comet.core.model.matchlets.Matchlet;
import org.fao.fi.comet.core.model.matchlets.MatchletConfiguration;
import org.fao.fi.comet.core.patterns.data.partitioners.DataPartitioner;
import org.fao.fi.comet.core.patterns.data.providers.DataProvider;
import org.fao.fi.comet.core.patterns.data.providers.FeedableDataProvider;
import org.fao.fi.comet.core.patterns.data.providers.ProvidedData;
import org.fao.fi.comet.core.patterns.data.providers.SizeAwareDataProvider;
import org.fao.fi.comet.core.patterns.data.providers.impl.basic.CollectionBackedDataProvider;
import org.fao.fi.comet.core.patterns.handlers.id.IDHandler;
import org.fao.fi.comet.core.uniform.matchlets.UMatchlet;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;

public class UMatchingEngineCore<ENTITY extends Serializable, CONFIG extends MatchingEngineProcessConfiguration>
extends MatchingEngineCore<ENTITY, ENTITY, CONFIG> {
    private static final long serialVersionUID = -8997497057603195116L;
    protected boolean _switchComparisonAndDomain = false;

    public UMatchingEngineCore() {
    }

    public UMatchingEngineCore(int parallelThreads) {
        super(parallelThreads);
    }

    public boolean getSwitchComparisonAndDomain() {
        return this._switchComparisonAndDomain;
    }

    public void setSwitchComparisonAndDomain(boolean switchComparisonAndDomain) {
        this._switchComparisonAndDomain = switchComparisonAndDomain;
    }

    @Override
    protected MatchingResult<?, ?> doPerformActualComparison(ENTITY source, DataIdentifier sourceIdentifier, ENTITY target, DataIdentifier targetIdentifier, Matchlet<ENTITY, ?, ENTITY, ?> matchlet) {
        return super.doPerformActualComparison(this._switchComparisonAndDomain ? target : source, this._switchComparisonAndDomain ? targetIdentifier : sourceIdentifier, this._switchComparisonAndDomain ? source : target, this._switchComparisonAndDomain ? sourceIdentifier : targetIdentifier, matchlet);
    }

    @Override
    protected Matching<ENTITY, ENTITY> doGetMatching(MatchingsData<ENTITY, ENTITY> currentMatchingData, DataIdentifier sourceIdentifier, DataIdentifier targetIdentifier, MatchingResult<?, ?> currentMatchingResult) {
        return super.doGetMatching(currentMatchingData, this._switchComparisonAndDomain ? targetIdentifier : sourceIdentifier, this._switchComparisonAndDomain ? sourceIdentifier : targetIdentifier, currentMatchingResult);
    }

    @Override
    protected Matching<ENTITY, ENTITY> doRemoveMatching(MatchingsData<ENTITY, ENTITY> currentMatchingData, DataIdentifier sourceIdentifier, DataIdentifier targetIdentifier) {
        return super.doRemoveMatching(currentMatchingData, this._switchComparisonAndDomain ? targetIdentifier : sourceIdentifier, this._switchComparisonAndDomain ? sourceIdentifier : targetIdentifier);
    }

    @Override
    protected MatchingDetails<ENTITY, ENTITY> doGetMatchingDetails(MatchingsData<ENTITY, ENTITY> currentMatchingData, DataIdentifier sourceIdentifier, DataIdentifier targetIdentifier) {
        return super.doGetMatchingDetails(currentMatchingData, this._switchComparisonAndDomain ? targetIdentifier : sourceIdentifier, this._switchComparisonAndDomain ? sourceIdentifier : targetIdentifier);
    }

    public final MatchingEngineProcessResult<ENTITY, ENTITY, CONFIG> compareAll(CONFIG configuration, MatchingProcessHandler<ENTITY> tracker, DataProvider<ENTITY> sources, DataPartitioner<ENTITY, ENTITY> partitioner, DataProvider<ENTITY> targets, IDHandler<ENTITY, ?> IDHandler2) throws MatchingProcessException {
        return this.compareAll(configuration, tracker, sources, partitioner, targets, IDHandler2, IDHandler2);
    }

    public final MatchingEngineProcessResult<ENTITY, ENTITY, CONFIG> compareAndFeedAll(CONFIG configuration, MatchingProcessHandler<ENTITY> tracker, FeedableDataProvider<ENTITY> sources, DataPartitioner<ENTITY, ENTITY> partitioner, IDHandler<ENTITY, ?> IDHandler2) throws MatchingProcessException {
        return this.compareAndFeedAll(configuration, tracker, sources, partitioner, new CollectionBackedDataProvider(), IDHandler2);
    }

    public final MatchingEngineProcessResult<ENTITY, ENTITY, CONFIG> compareAndFeedAll(CONFIG configuration, MatchingProcessHandler<ENTITY> tracker, FeedableDataProvider<ENTITY> sources, DataPartitioner<ENTITY, ENTITY> partitioner, DataProvider<ENTITY> targets, IDHandler<ENTITY, ?> IDHandler2) throws MatchingProcessException {
        AssertionUtils.$nNull(configuration, "Configuration cannot be null", new Object[0]);
        AssertionUtils.$nNull(tracker, "Tracker cannot be null", new Object[0]);
        AssertionUtils.$nNull(sources, "Sources data cannot be null", new Object[0]);
        AssertionUtils.$_assert(sources.iterator().hasNext(), "The sources must contain at least one element", new Object[0]);
        AssertionUtils.$nNull(partitioner, "Sources partitioner cannot be null", new Object[0]);
        AssertionUtils.$nNull(targets, "Targets data cannot be null", new Object[0]);
        ((MatchingEngineProcessConfiguration)configuration).validate();
        Collection<UMatchlet<ENTITY, ?>> matchlets = this.initializeMatchlets(configuration);
        AssertionUtils.$nEm(matchlets, "Matchlets cannot be null or empty", new Object[0]);
        AssertionUtils.$nNull(IDHandler2, "ID handler cannot be null", new Object[0]);
        MatchingsData results = new MatchingsData();
        tracker.notifyComparisonProcessStarted(tracker.getProcessId());
        if (targets instanceof SizeAwareDataProvider) {
            tracker.setNumberOfComparisonRounds(((SizeAwareDataProvider)targets).getAvailableDataSize());
        }
        for (ProvidedData providedData : targets) {
            if (!tracker.isRunning()) break;
            tracker.notifyComparisonRoundStart(providedData);
            results = this.performComparison(configuration, tracker, results, sources, providedData.getData(), providedData.getProviderId(), partitioner, matchlets, IDHandler2, IDHandler2);
            tracker.notifyComparisonRoundPerformed(providedData);
            sources.addData(providedData);
        }
        tracker.notifyComparisonProcessCompleted();
        this.cleanup((MatchingEngineProcessConfiguration)configuration, results);
        MatchingEngineProcessorInfo<CONFIG> matchingEngineProcessorInfo = new MatchingEngineProcessorInfo<CONFIG>(this.updateConfiguration(matchlets, configuration), tracker.getProcessStatus());
        return new MatchingEngineProcessResult(matchingEngineProcessorInfo, results);
    }

    private Collection<UMatchlet<ENTITY, ?>> initializeMatchlets(CONFIG configuration) throws MatchletConfigurationException {
        if (configuration == null || ((MatchingEngineProcessConfiguration)configuration).getMatchletsConfigurations() == null || ((MatchingEngineProcessConfiguration)configuration).getMatchletsConfigurations().isEmpty()) {
            return null;
        }
        ArrayList matchlets = new ArrayList();
        ServiceLoader<Matchlet> loader = ServiceLoader.load(Matchlet.class);
        for (MatchletConfiguration matchletConfig : ((MatchingEngineProcessConfiguration)configuration).getMatchletsConfigurations()) {
            boolean provided = false;
            for (Matchlet matchlet : loader) {
                if (!(matchlet instanceof UMatchlet) || !matchlet.getName().equals(matchletConfig.getMatchletId())) continue;
                matchlet.configure(matchletConfig.getMatchletParameters());
                matchlets.add((UMatchlet)matchlet);
                provided = true;
                break;
            }
            if (provided) continue;
            throw new MatchletConfigurationException("No provider available for matchlet named " + matchletConfig.getMatchletId());
        }
        if (matchlets.isEmpty()) {
            return null;
        }
        return matchlets;
    }
}

