/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.matchlets.extended;

import java.util.Collection;
import java.util.Map;
import org.fao.fi.comet.core.exceptions.MatchletConfigurationException;
import org.fao.fi.comet.core.model.common.LinkedTypedComplexName;
import org.fao.fi.comet.core.model.common.TypedComplexName;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletIsOptionalByDefault;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletParameter;
import org.fao.fi.comet.domain.species.matchlets.extended.AbstractCNameVectorialMatchlet;
import org.fao.fi.comet.domain.species.model.InputSpeciesData;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.vrmf.core.extensions.collections.impl.ListSet;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;

@MatchletIsOptionalByDefault
public class VernacularCNameMatchlet
extends AbstractCNameVectorialMatchlet {
    private static final long serialVersionUID = 2057284178844548705L;
    public static final String SUGGESTED_LANGS_PARAM = "suggestedLanguages";
    public static final String INCLUDE_UNKNOWN_LANGUAGE_PARAM = "includeUnknownLanguage";
    public static final String NAME = "VernacularNameMatchlet";
    @MatchletParameter(name="suggestedLanguages", description="Sets one (or many) of the available language names as the source of data being compared. It can be set to a comma-separated sequence of values.")
    private String _suggestedLanguages;
    @MatchletParameter(name="includeUnknownLanguage", description="When enabled, the matchlet will treat vernacular name in unknown languages as always valid during comparison")
    private Boolean _includeUnknownLanguage;

    public VernacularCNameMatchlet() {
        this.setCombinationCriteria("AND");
        this._suggestedLanguages = null;
        this._includeUnknownLanguage = Boolean.TRUE;
        this._name = NAME;
    }

    public VernacularCNameMatchlet(double levenshteinWeight, double soundexWeight, double trigramWeight) {
        super(levenshteinWeight, soundexWeight, trigramWeight);
        this._suggestedLanguages = null;
        this._includeUnknownLanguage = Boolean.TRUE;
        this._name = NAME;
    }

    public VernacularCNameMatchlet(double levenshteinWeight, double soundexWeight, double trigramWeight, String suggestedLanguages, Boolean includeUnknownLanguage) {
        this(levenshteinWeight, soundexWeight, trigramWeight);
        this._suggestedLanguages = suggestedLanguages != null ? suggestedLanguages : null;
        this._includeUnknownLanguage = Boolean.TRUE.equals(includeUnknownLanguage);
    }

    @Override
    public String getDescription() {
        return "Matches multiple language-specific names as extracted from a pair of input / reference matched entities";
    }

    @Override
    protected void doValidateConfiguration() throws MatchletConfigurationException {
        super.doValidateConfiguration();
        if (this._suggestedLanguages != null) {
            String[] stringArray = this._suggestedLanguages.split("\\,");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String language = stringArray[n2];
                language = StringUtils.rawTrim(language);
                AssertionUtils.$nNull(language, "{} cannot be configured with a NULL-equivalent suggested language", this.getClass().getSimpleName());
                ++n2;
            }
        }
    }

    public String getSuggestedLanguages() {
        return this._suggestedLanguages;
    }

    public void setSuggestedLanguages(String suggestedLanguages) {
        this._suggestedLanguages = suggestedLanguages;
    }

    public Boolean getIncludeUnknownLanguage() {
        return this._includeUnknownLanguage;
    }

    public void setIncludeUnknownLanguage(Boolean includeUnknownLanguage) {
        this._includeUnknownLanguage = includeUnknownLanguage;
    }

    @Override
    protected Collection<TypedComplexName> doExtractData(ReferenceSpeciesData entity, DataIdentifier dataIdentifier) {
        int n;
        if (entity.getVernacularCNames() == null || entity.getVernacularCNames().length == 0) {
            return null;
        }
        ListSet<TypedComplexName> data = new ListSet<TypedComplexName>();
        Map<String, TypedComplexName[]> complexNamesMap = entity.getComplexNamesMap();
        boolean hasNameInSuggestedLanguage = false;
        ListSet suggestedLanguages = new ListSet();
        if (Boolean.TRUE.equals(this._includeUnknownLanguage)) {
            suggestedLanguages.add("vernacular_UNKNOWN");
        }
        if (this._suggestedLanguages != null) {
            String[] stringArray = this._suggestedLanguages.split("\\,");
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String suggestedLanguage = stringArray[n2];
                if ((suggestedLanguage = StringUtils.rawTrim(suggestedLanguage)) != null) {
                    suggestedLanguages.add("vernacular_" + suggestedLanguage);
                }
                ++n2;
            }
        }
        if (!suggestedLanguages.isEmpty()) {
            for (String suggestedLanguage : suggestedLanguages) {
                suggestedLanguage = StringUtils.rawTrim(suggestedLanguage);
                if (!this._includeUnknownLanguage.booleanValue() && !complexNamesMap.containsKey(suggestedLanguage)) continue;
                hasNameInSuggestedLanguage = true;
                break;
            }
        }
        boolean isSimpleSpecies = entity instanceof InputSpeciesData;
        if (this._suggestedLanguages != null) {
            if (!hasNameInSuggestedLanguage && !isSimpleSpecies) {
                return null;
            }
        } else {
            LinkedTypedComplexName[] linkedTypedComplexNameArray = entity.getVernacularCNames();
            int n3 = linkedTypedComplexNameArray.length;
            n = 0;
            while (n < n3) {
                LinkedTypedComplexName vernacular = linkedTypedComplexNameArray[n];
                data.add(vernacular);
                ++n;
            }
        }
        if (!suggestedLanguages.isEmpty()) {
            for (String suggestedLanguage : suggestedLanguages) {
                String key = suggestedLanguage;
                if (!complexNamesMap.containsKey(key)) continue;
                TypedComplexName[] typedComplexNameArray = complexNamesMap.get(key);
                int n4 = typedComplexNameArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    TypedComplexName vernacular = typedComplexNameArray[n5];
                    data.add(vernacular);
                    ++n5;
                }
            }
        }
        return data;
    }
}

