/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.converters.dwca;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.fao.fi.comet.core.model.common.LinkedTypedComplexName;
import org.fao.fi.comet.domain.species.ReferenceSpeciesFactory;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.model.VernacularNameData;
import org.fao.fi.comet.domain.species.tools.io.support.ReferenceDataConverter;
import org.fao.fi.comet.domain.species.tools.io.support.impl.DefaultTAFReferenceDataConverter;
import org.fao.fi.comet.domain.species.tools.lexical.processors.LexicalProcessorsUtils;
import org.fao.fi.comet.domain.species.tools.lexical.processors.impl.AuthoritiesNormalizerProcessor;
import org.fao.fi.comet.domain.species.tools.lexical.processors.queue.AuthoritiesSimplifier;
import org.fao.fi.comet.domain.species.tools.lexical.processors.queue.SpeciesNormalizer;
import org.fao.fi.comet.domain.species.tools.lexical.processors.queue.SpeciesSimplifier;
import org.fao.vrmf.core.extensions.collections.impl.ListSet;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.fao.vrmf.core.helpers.singletons.text.xml.XMLBuilderUtils;
import org.fao.vrmf.core.impl.logging.ImmutableLoggingClient;
import org.fao.vrmf.core.tools.lexical.processors.LexicalProcessor;
import org.fao.vrmf.core.tools.lexical.soundex.PhraseSoundexGenerator;
import org.fao.vrmf.core.tools.lexical.soundex.SoundexGenerator;
import org.fao.vrmf.core.tools.lexical.soundex.impl.BasicSoundexGenerator;
import org.fao.vrmf.core.tools.lexical.soundex.impl.ExtendedPhraseSoundexGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class DWCAToReferenceDataCSVConverter
extends ImmutableLoggingClient {
    protected final DocumentBuilderFactory _builderFactory;
    protected final DocumentBuilder _documentBuilder;
    protected final XPathFactory _xPathFactory;
    protected final LexicalProcessor _speciesSimplifierProcessor;
    protected final LexicalProcessor _speciesNormalizerProcessor;
    protected final LexicalProcessor _authoritiesSimplifierProcessor;
    protected final LexicalProcessor _authoritiesNormalizerProcessor = new AuthoritiesNormalizerProcessor();
    protected final PhraseSoundexGenerator _phraseSoundexer = new ExtendedPhraseSoundexGenerator();
    protected final SoundexGenerator _soundexer = new BasicSoundexGenerator();
    private static final String CORE_XPATH = "/archive/core";
    private static final String EXTENSION_XPATH = "/archive/extension";
    private static final String ENCODING_XPATH = "/@encoding";
    private static final String LINES_TERMINATED_BY_XPATH = "/@linesTerminatedBy";
    private static final String FIELDS_TERMINATED_BY_XPATH = "/@fieldsTerminatedBy";
    private static final String FIELDS_ENCLOSED_BY_XPATH = "/@fieldsEnclosedBy";
    private static final String IGNORE_HEADER_LINES_XPATH = "/@ignoreHeaderLines";
    private static final String FILES_LOCATION_XPATH = "/files/location";
    private static final String CORE_FILES_LOCATION = "/archive/core/files/location";
    private static final String EXTENSION_FILES_LOCATION = "/archive/extension/files/location";
    private static final String CORE_ENCODING_XPATH = "/archive/core/@encoding";
    private static final String CORE_LINES_TERMINATED_BY_XPATH = "/archive/core/@linesTerminatedBy";
    private static final String CORE_FIELDS_TERMINATED_BY_XPATH = "/archive/core/@fieldsTerminatedBy";
    private static final String CORE_FIELDS_ENCLOSED_BY_XPATH = "/archive/core/@fieldsEnclosedBy";
    private static final String CORE_IGNORE_HEADER_LINES_XPATH = "/archive/core/@ignoreHeaderLines";
    private static final String EXTENSION_ENCODING_XPATH = "/archive/extension/@encoding";
    private static final String EXTENSION_LINES_TERMINATED_BY_XPATH = "/archive/extension/@linesTerminatedBy";
    private static final String EXTENSION_FIELDS_TERMINATED_BY_XPATH = "/archive/extension/@fieldsTerminatedBy";
    private static final String EXTENSION_FIELDS_ENCLOSED_BY_XPATH = "/archive/extension/@fieldsEnclosedBy";
    private static final String EXTENSION_IGNORE_HEADER_LINES_XPATH = "/archive/extension/@ignoreHeaderLines";
    private static final String ID_XPATH = "/archive/core/id/@index";
    private static final String KINGDOM_XPATH = "/archive/core/field[@term='http://rs.tdwg.org/dwc/terms/kingdom']/@index";
    private static final String PHYLUM_XPATH = "/archive/core/field[@term='http://rs.tdwg.org/dwc/terms/phylum']/@index";
    private static final String CLASS_XPATH = "/archive/core/field[@term='http://rs.tdwg.org/dwc/terms/class']/@index";
    private static final String ORDER_XPATH = "/archive/core/field[@term='http://rs.tdwg.org/dwc/terms/order']/@index";
    private static final String FAMILY_XPATH = "/archive/core/field[@term='http://rs.tdwg.org/dwc/terms/family']/@index";
    private static final String GENUS_XPATH = "/archive/core/field[@term='http://rs.tdwg.org/dwc/terms/genus']/@index";
    private static final String SUBGENUS_XPATH = "/archive/core/field[@term='http://rs.tdwg.org/dwc/terms/subgenus']/@index";
    private static final String SPECIFIC_EPITHET_XPATH = "/archive/core/field[@term='http://rs.tdwg.org/dwc/terms/specificEpithet']/@index";
    private static final String ISPECIFIC_EPITHET_XPATH = "/archive/core/field[@term='http://rs.tdwg.org/dwc/terms/infraspecificEpithet']/@index";
    private static final String SCIENTIFIC_NAME_XPATH = "/archive/core/field[@term='http://rs.tdwg.org/dwc/terms/scientificName']/@index";
    private static final String SN_AUTHORSHIP_XPATH = "/archive/core/field[@term='http://rs.tdwg.org/dwc/terms/scientificNameAuthorship']/@index";
    private static final String NA_AUTHORSHIP_XPATH = "/archive/core/field[@term='http://rs.tdwg.org/dwc/terms/nameAccordingTo']/@index";
    private static final String TAXON_RANK_XPATH = "/archive/core/field[@term='http://rs.tdwg.org/dwc/terms/taxonRank']/@index";
    private static final String VERNACULAR_ID_XPATH = "/archive/extension/coreid/@index";
    private static final String VERNACULAR_NAME_XPATH = "/archive/extension/field[@term='http://rs.tdwg.org/dwc/terms/vernacularName']/@index";
    private static final String VERNACULAR_LANGUAGE_XPATH = "/archive/extension/field[@term='http://purl.org/dc/terms/language']/@index";
    private static final String VERNACULAR_LOCALITY_XPATH = "/archive/extension/field[@term='http://rs.tdwg.org/dwc/terms/locality']/@index";
    private static final ReferenceDataConverter<ReferenceSpeciesData> CONVERTER = new DefaultTAFReferenceDataConverter();
    static Map<String, XPathExpression> XPATH_EXPR_MAP = new HashMap<String, XPathExpression>();

    public DWCAToReferenceDataCSVConverter() throws Throwable {
        this._builderFactory = DocumentBuilderFactory.newInstance();
        this._builderFactory.setNamespaceAware(true);
        this._documentBuilder = this._builderFactory.newDocumentBuilder();
        this._xPathFactory = XPathFactory.newInstance();
        this._speciesSimplifierProcessor = LexicalProcessorsUtils.getProcessor(SpeciesSimplifier.class);
        this._authoritiesSimplifierProcessor = LexicalProcessorsUtils.getProcessor(AuthoritiesSimplifier.class);
        this._speciesNormalizerProcessor = LexicalProcessorsUtils.getProcessor(SpeciesNormalizer.class);
    }

    private XPathExpression compile(String xpath) throws XPathExpressionException {
        XPathExpression expr = XPATH_EXPR_MAP.get(xpath);
        if (expr == null) {
            expr = this._xPathFactory.newXPath().compile(xpath);
            XPATH_EXPR_MAP.put(xpath, expr);
        }
        return expr;
    }

    private String getString(String xpath, Document document) throws Throwable {
        return StringUtils.rawTrim((String)this.compile(xpath).evaluate(document, XPathConstants.STRING));
    }

    private Map<String, Object> parseCoreMetadata(Document meta) throws Throwable {
        this._log.info("Parsing core metadata...");
        HashMap<String, Object> parsed = new HashMap<String, Object>();
        parsed.put("encoding", this.getString(CORE_ENCODING_XPATH, meta));
        parsed.put("lineTerminator", this.getString(CORE_LINES_TERMINATED_BY_XPATH, meta));
        parsed.put("fieldsDelimiter", this.getString(CORE_FIELDS_ENCLOSED_BY_XPATH, meta));
        parsed.put("fieldsTerminator", this.getString(CORE_FIELDS_TERMINATED_BY_XPATH, meta));
        parsed.put("headerLines", this.getString(CORE_IGNORE_HEADER_LINES_XPATH, meta));
        ListSet files = new ListSet();
        NodeList filesNodes = (NodeList)this.compile(CORE_FILES_LOCATION).evaluate(meta, XPathConstants.NODESET);
        if (filesNodes != null) {
            int n = 0;
            while (n < filesNodes.getLength()) {
                String file = filesNodes.item(n).getTextContent();
                if (file != null) {
                    files.add(file);
                }
                ++n;
            }
            parsed.put("files", files);
        }
        return parsed;
    }

    private Map<String, Object> parseExtensionMetadata(Document meta) throws Throwable {
        this._log.info("Parsing extensions metadata...");
        HashMap<String, Object> parsed = new HashMap<String, Object>();
        parsed.put("encoding", this.getString(EXTENSION_ENCODING_XPATH, meta));
        parsed.put("lineTerminator", this.getString(EXTENSION_LINES_TERMINATED_BY_XPATH, meta));
        parsed.put("fieldsDelimiter", this.getString(EXTENSION_FIELDS_ENCLOSED_BY_XPATH, meta));
        parsed.put("fieldsTerminator", this.getString(EXTENSION_FIELDS_TERMINATED_BY_XPATH, meta));
        parsed.put("headerLines", this.getString(EXTENSION_IGNORE_HEADER_LINES_XPATH, meta));
        ListSet files = new ListSet();
        NodeList filesNodes = (NodeList)this.compile(EXTENSION_FILES_LOCATION).evaluate(meta, XPathConstants.NODESET);
        if (filesNodes != null) {
            int n = 0;
            while (n < filesNodes.getLength()) {
                String file = filesNodes.item(n).getTextContent();
                if (file != null) {
                    files.add(file);
                }
                ++n;
            }
            parsed.put("files", files);
        }
        return parsed;
    }

    private Map<String, Integer> extractExtensionIndexes(Document meta) throws Throwable {
        this._log.info("Extracting extensions indexes...");
        HashMap<String, Integer> parsed = new HashMap<String, Integer>();
        String index = StringUtils.rawTrim(this.compile(VERNACULAR_ID_XPATH).evaluate(meta, XPathConstants.STRING).toString());
        if (index != null) {
            parsed.put("parentId", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(VERNACULAR_LANGUAGE_XPATH).evaluate(meta, XPathConstants.STRING).toString())) != null) {
            parsed.put("language", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(VERNACULAR_LOCALITY_XPATH).evaluate(meta, XPathConstants.STRING).toString())) != null) {
            parsed.put("locality", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(VERNACULAR_NAME_XPATH).evaluate(meta, XPathConstants.STRING).toString())) != null) {
            parsed.put("name", Integer.valueOf(index.toString()));
        }
        return parsed;
    }

    private Map<String, Integer> extractCoreIndexes(Document meta) throws Throwable {
        this._log.info("Extracting core indexes...");
        HashMap<String, Integer> parsed = new HashMap<String, Integer>();
        String index = StringUtils.rawTrim(this.compile(ID_XPATH).evaluate(meta, XPathConstants.STRING).toString());
        if (index != null) {
            parsed.put("id", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(KINGDOM_XPATH).evaluate(meta))) != null) {
            parsed.put("kingdom", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(PHYLUM_XPATH).evaluate(meta))) != null) {
            parsed.put("phylum", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(CLASS_XPATH).evaluate(meta))) != null) {
            parsed.put("class", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(ORDER_XPATH).evaluate(meta))) != null) {
            parsed.put("order", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(FAMILY_XPATH).evaluate(meta))) != null) {
            parsed.put("family", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(GENUS_XPATH).evaluate(meta))) != null) {
            parsed.put("genus", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(SUBGENUS_XPATH).evaluate(meta))) != null) {
            parsed.put("subgenus", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(SPECIFIC_EPITHET_XPATH).evaluate(meta))) != null) {
            parsed.put("specificEpithet", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(ISPECIFIC_EPITHET_XPATH).evaluate(meta))) != null) {
            parsed.put("infraspecificEpithet", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(SCIENTIFIC_NAME_XPATH).evaluate(meta))) != null) {
            parsed.put("scientificName", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(SN_AUTHORSHIP_XPATH).evaluate(meta))) != null) {
            parsed.put("authorship", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(NA_AUTHORSHIP_XPATH).evaluate(meta))) != null) {
            parsed.put("authorshipAccordingTo", Integer.valueOf(index.toString()));
        }
        if ((index = StringUtils.rawTrim(this.compile(TAXON_RANK_XPATH).evaluate(meta))) != null) {
            parsed.put("taxonRank", Integer.valueOf(index.toString()));
        }
        return parsed;
    }

    private String sanitize(String toSanitize) {
        if ("not assigned".equalsIgnoreCase(toSanitize = StringUtils.rawTrim(toSanitize))) {
            toSanitize = null;
        }
        return toSanitize;
    }

    private String getPart(String[] parts, Map<String, Integer> meta, String element) {
        if (meta.containsKey(element)) {
            return StringUtils.rawTrim(parts[meta.get(element)]);
        }
        return null;
    }

    public void convertTaxaData(String providerId, String taxaDataFile, Map<String, Object> meta, Map<String, Integer> indexes, PrintWriter taxaWriter) throws Throwable {
        this._log.info("Reading and converting {} taxa data from {}...", (Object)providerId, (Object)taxaDataFile);
        InputStreamReader is = null;
        BufferedReader br = null;
        try {
            String line;
            is = new InputStreamReader((InputStream)new FileInputStream(taxaDataFile), ObjectsUtils.coalesce((String)meta.get("encoding"), "UTF-8"));
            br = new BufferedReader(is);
            Integer linesToSkip = 0;
            if (meta.get("headerLines") != null) {
                try {
                    linesToSkip = Integer.valueOf((String)meta.get("headerLines"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ArrayList<ReferenceSpeciesData> data = new ArrayList<ReferenceSpeciesData>();
            String fieldsDelimiter = (String)meta.get("fieldsDelimiter");
            int lines = 0;
            int withLongNameAccordingTo = 0;
            int withNameAccordingTo = 0;
            int withAuthorship = 0;
            taxaWriter.println(CONVERTER.serializeTaxaHeader());
            while ((line = br.readLine()) != null) {
                if ((linesToSkip = Integer.valueOf(linesToSkip - 1)) >= 0) continue;
                ++lines;
                String[] parts = line.split(ObjectsUtils.coalesce((String)meta.get("fieldsTerminator"), "\\t"), -1);
                ReferenceSpeciesData entry = new ReferenceSpeciesData();
                entry.setDataSource(providerId);
                entry.setId(this.getPart(parts, indexes, "id"));
                String taxonRank = this.sanitize(this.unwrap(this.getPart(parts, indexes, "taxonRank"), fieldsDelimiter));
                String scientificName = this.sanitize(this.unwrap(this.getPart(parts, indexes, "scientificName"), fieldsDelimiter));
                String genus = this.sanitize(this.unwrap(this.getPart(parts, indexes, "genus"), fieldsDelimiter));
                String subgenus = this.sanitize(this.unwrap(this.getPart(parts, indexes, "subgenus"), fieldsDelimiter));
                String specificEpithet = this.sanitize(this.unwrap(this.getPart(parts, indexes, "specificEpithet"), fieldsDelimiter));
                String infraspecificEpithet = this.sanitize(this.unwrap(this.getPart(parts, indexes, "infraspecificEpithet"), fieldsDelimiter));
                entry.setKingdom(this.sanitize(this.unwrap(this.getPart(parts, indexes, "kingdom"), fieldsDelimiter)));
                entry.setPhylum(this.sanitize(this.unwrap(this.getPart(parts, indexes, "phylum"), fieldsDelimiter)));
                entry.setKlass(this.sanitize(this.unwrap(this.getPart(parts, indexes, "class"), fieldsDelimiter)));
                entry.setOrder(this.sanitize(this.unwrap(this.getPart(parts, indexes, "order"), fieldsDelimiter)));
                entry.setFamily(this.sanitize(this.unwrap(this.getPart(parts, indexes, "family"), fieldsDelimiter)));
                entry.setScientificName(scientificName);
                this.updateEntry(entry, taxonRank, scientificName, genus, subgenus, specificEpithet, infraspecificEpithet);
                String authorship = this.sanitize(this.unwrap(this.getPart(parts, indexes, "authorship"), fieldsDelimiter));
                String nameAccordingTo = this.sanitize(this.unwrap(this.getPart(parts, indexes, "authorshipAccordingTo"), fieldsDelimiter));
                if (authorship != null) {
                    ++withAuthorship;
                    entry.setAuthor(authorship);
                }
                if (authorship == null && nameAccordingTo != null) {
                    ++withNameAccordingTo;
                    if (nameAccordingTo.length() > 64) {
                        ++withLongNameAccordingTo;
                        this._log.debug("Entry {} has no authorship but a LONG ({} chars) 'name according to...' [ {} ]", new Object[]{entry.getId(), nameAccordingTo.length(), nameAccordingTo});
                    } else {
                        entry.setAuthor(nameAccordingTo);
                    }
                }
                entry = ReferenceSpeciesFactory.updateComplexNames(entry, this._speciesSimplifierProcessor, this._speciesNormalizerProcessor, this._authoritiesSimplifierProcessor, this._authoritiesNormalizerProcessor, this._phraseSoundexer, this._soundexer);
                data.add(entry);
                if (lines % 1000 != 0) continue;
                this.writeConvertedTaxaData(data, providerId, CONVERTER, taxaWriter);
                data.clear();
                this._log.info("Read and converted {} lines so far...", (Object)lines);
            }
            if (!data.isEmpty()) {
                this.writeConvertedTaxaData(data, providerId, CONVERTER, taxaWriter);
            }
            this._log.info("Read and converted {} lines from {}", (Object)lines, (Object)taxaDataFile);
            this._log.info("{} entries have authorship, {} have no authorship but a 'name according to...', of which {} are longer than 64 chars", new Object[]{withAuthorship, withNameAccordingTo, withLongNameAccordingTo});
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    private void updateEntry(ReferenceSpeciesData entry, String taxonRank, String scientificName, String genus, String subgenus, String specificEpithet, String infraspecificEpithet) {
        entry.setScientificName(scientificName);
        if ("kingdom".equalsIgnoreCase(taxonRank)) {
            entry.setKingdom(scientificName);
        } else if ("phylum".equalsIgnoreCase(taxonRank)) {
            entry.setPhylum(scientificName);
        } else if ("class".equalsIgnoreCase(taxonRank)) {
            entry.setKlass(scientificName);
        } else if ("order".equalsIgnoreCase(taxonRank)) {
            entry.setOrder(scientificName);
        } else if ("family".equalsIgnoreCase(taxonRank)) {
            entry.setFamily(scientificName);
        } else if ("genus".equalsIgnoreCase(taxonRank)) {
            entry.setGenus(scientificName);
        }
        if (genus == null) {
            entry.setGenus(scientificName);
            return;
        }
        entry.setGenus(genus);
        if (subgenus == null) {
            String species = specificEpithet == null ? "" : specificEpithet;
            species = String.valueOf(species) + (infraspecificEpithet == null ? "" : " " + infraspecificEpithet);
            if ("".equals(species = species.trim())) {
                species = null;
            }
            entry.setSpecies(species);
        } else {
            entry.setSpecies(infraspecificEpithet);
        }
    }

    public void convertVernacularNameData(String providerId, String vernacularDataFile, Map<String, Object> meta, Map<String, Integer> indexes, PrintWriter vernacularWriter) throws Throwable {
        this._log.info("Reading {} vernacular names data from {}...", (Object)providerId, (Object)vernacularDataFile);
        InputStreamReader is = null;
        BufferedReader br = null;
        try {
            String line;
            String encoding = (String)meta.get("encoding");
            is = new InputStreamReader((InputStream)new FileInputStream(vernacularDataFile), ObjectsUtils.coalesce(encoding, "UTF-8"));
            br = new BufferedReader(is);
            Integer linesToSkip = 0;
            if (meta.get("headerLines") != null) {
                try {
                    linesToSkip = Integer.valueOf((String)meta.get("headerLines"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ArrayList<LinkedTypedComplexName> data = new ArrayList();
            ArrayList<VernacularNameData> deserializedData = new ArrayList<VernacularNameData>();
            String fieldsDelimiter = (String)meta.get("fieldsDelimiter");
            int lines = 0;
            ReferenceSpeciesData dummy = new ReferenceSpeciesData();
            vernacularWriter.println(CONVERTER.serializeVernacularNamesHeader());
            while ((line = br.readLine()) != null) {
                if ((linesToSkip = Integer.valueOf(linesToSkip - 1)) >= 0) continue;
                ++lines;
                String[] parts = line.split(ObjectsUtils.coalesce((String)meta.get("fieldsTerminator"), "\\t"), -1);
                VernacularNameData deserializedEntry = new VernacularNameData();
                deserializedEntry.setParentId(this.unwrap(this.getPart(parts, indexes, "parentId"), fieldsDelimiter));
                deserializedEntry.setLanguage(this.unwrap(this.getPart(parts, indexes, "language"), fieldsDelimiter));
                if (deserializedEntry.getLanguage() == null) {
                    deserializedEntry.setLanguage("UNKNOWN");
                }
                deserializedEntry.setLocality(this.unwrap(this.getPart(parts, indexes, "locality"), fieldsDelimiter));
                deserializedEntry.setName(this.unwrap(this.getPart(parts, indexes, "name"), fieldsDelimiter));
                deserializedData.add(deserializedEntry);
                if ("CatalogueOfLife:13694666".equals(deserializedEntry.getParentId())) {
                    System.out.println("SUNCHI!");
                }
                if (lines % 1000 != 0) continue;
                dummy.setVernacularNames(deserializedData.toArray(new VernacularNameData[deserializedData.size()]));
                dummy = ReferenceSpeciesFactory.updateComplexNames(dummy, this._speciesSimplifierProcessor, this._speciesNormalizerProcessor, this._authoritiesSimplifierProcessor, this._authoritiesNormalizerProcessor, this._phraseSoundexer, this._soundexer);
                data = Arrays.asList(dummy.getVernacularCNames());
                this.writeConvertedVernacularData(data, providerId, CONVERTER, vernacularWriter);
                deserializedData.clear();
                dummy.setVernacularNames(null);
                dummy.setVernacularCNames(null);
                this._log.info("Read and converted {} lines so far...", (Object)lines);
            }
            if (!deserializedData.isEmpty()) {
                dummy.setVernacularNames(deserializedData.toArray(new VernacularNameData[deserializedData.size()]));
                dummy = ReferenceSpeciesFactory.updateComplexVernacularNames(dummy, this._speciesSimplifierProcessor, this._speciesNormalizerProcessor, this._authoritiesSimplifierProcessor, this._authoritiesNormalizerProcessor, this._phraseSoundexer, this._soundexer);
                data = Arrays.asList(dummy.getVernacularCNames());
                this.writeConvertedVernacularData(data, providerId, CONVERTER, vernacularWriter);
                this._log.info("Read and converted {} lines from {}", (Object)lines, (Object)vernacularDataFile);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    public void convertData(String providerId, String sourceFolder, PrintWriter targetTaxaWriter, PrintWriter targetVernacularWriter) throws Throwable {
        File path;
        this._log.info("Building data for {} from {}", (Object)providerId, (Object)sourceFolder);
        AssertionUtils.$nNull(sourceFolder, "Please specify a non-null DWCA data folder", new Object[0]);
        File dwcaFolder = new File(sourceFolder);
        AssertionUtils.$true(dwcaFolder.isDirectory(), "The specified path ({}) doesn't resolve to a folder", sourceFolder);
        AssertionUtils.$true(dwcaFolder.exists(), "The specified path ({}) doesn't exist", sourceFolder);
        File metaFile = new File(dwcaFolder, "meta.xml");
        AssertionUtils.$true(metaFile.exists(), "The specified path ({}) doesn't include a 'meta.xml' file", sourceFolder);
        Document meta = XMLBuilderUtils.convertToDocument(metaFile);
        Map<String, Object> coreMeta = this.parseCoreMetadata(meta);
        Map<String, Object> extensionsMeta = this.parseExtensionMetadata(meta);
        Map<String, Integer> coreIndexes = this.extractCoreIndexes(meta);
        Map<String, Integer> extensionsIndexes = this.extractExtensionIndexes(meta);
        List coreFiles = (List)coreMeta.get("files");
        List extensionsFiles = (List)extensionsMeta.get("files");
        AssertionUtils.$nNull(coreFiles, "Unable to read the core fileset from {}", metaFile.getAbsolutePath());
        AssertionUtils.$nEm(coreFiles, "The 'meta.xml' inside {} doesn't list any core fileset", sourceFolder);
        for (String file : coreFiles) {
            path = new File(file);
            if (!path.exists()) {
                path = new File(dwcaFolder, file);
            }
            AssertionUtils.$true(path.exists(), "Path to core file {} doesn't exist", path);
            AssertionUtils.$true(path.isFile(), "Path to core file {} is not a file", path);
            this.convertTaxaData(providerId, path.getAbsolutePath(), coreMeta, coreIndexes, targetTaxaWriter);
        }
        if (extensionsFiles != null && !extensionsFiles.isEmpty()) {
            for (String file : extensionsFiles) {
                path = new File(file);
                if (!path.exists()) {
                    path = new File(dwcaFolder, file);
                }
                AssertionUtils.$true(path.exists(), "Path to extensions file {} doesn't exist", path);
                AssertionUtils.$true(path.isFile(), "Path to extensions file {} is not a file", path);
                this.convertVernacularNameData(providerId, path.getAbsolutePath(), extensionsMeta, extensionsIndexes, targetVernacularWriter);
            }
        }
    }

    public void writeConvertedTaxaData(Collection<ReferenceSpeciesData> data, String providerId, ReferenceDataConverter<ReferenceSpeciesData> converter, PrintWriter taxaWriter) throws IOException {
        this._log.info("Writing {} taxa data for {}...", (Object)data.size(), (Object)providerId);
        for (ReferenceSpeciesData currentData : data) {
            taxaWriter.println(converter.serializeTaxa(currentData, providerId));
        }
        taxaWriter.flush();
    }

    public void writeConvertedVernacularData(Collection<LinkedTypedComplexName> data, String providerId, ReferenceDataConverter<ReferenceSpeciesData> converter, PrintWriter vernacularNamesWriter) throws IOException {
        this._log.info("Writing {} vernacular name data for {}...", (Object)data.size(), (Object)providerId);
        for (LinkedTypedComplexName currentData : data) {
            vernacularNamesWriter.println(converter.serializeVernacularName(currentData, currentData.getParentId(), providerId));
            vernacularNamesWriter.flush();
        }
        vernacularNamesWriter.flush();
    }

    private String unwrap(String text, String enclosingSequence) {
        if (text == null || enclosingSequence == null || "".equals(enclosingSequence)) {
            return text;
        }
        if (text.startsWith(enclosingSequence)) {
            text = text.substring(enclosingSequence.length());
        }
        if (text.endsWith(enclosingSequence)) {
            text = text.substring(0, text.length() - enclosingSequence.length());
        }
        return StringUtils.rawTrim(text);
    }
}

