/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.converters.dwca.cli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.fao.fi.comet.domain.species.tools.converters.dwca.DWCAToReferenceDataCSVConverter;
import org.fao.vrmf.core.helpers.singletons.io.EncryptionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DWCAConverter {
    private static Logger LOG = LoggerFactory.getLogger(DWCAConverter.class);
    private static final String VERSION = "1.2.0";
    private static final String HELP = "h";
    private static final String INPUT_FILE = "inFile";
    private static final String OUTPUT_DIR = "outDir";
    private static final String PROVIDER_ID = "providerId";

    private Options buildOptions() {
        Options options = new Options();
        options.addOption(new Option(HELP, false, "Print this message"));
        options.addOption(new Option(INPUT_FILE, true, "Specify an input file (either a DWCA file or a folder containing an exploded DWCA file content)"));
        options.addOption(new Option(OUTPUT_DIR, true, "Specify the output folder that will contain the .taf.gz files resulting from the conversion of the input DWCA"));
        options.addOption(new Option(PROVIDER_ID, true, "Specify the provider ID. This will have impact on the name of the .taf.gz files generated by the conversion, that will be <provider ID>_taxa.taf.gz and <provider ID>_vernacular.taf.gz"));
        return options;
    }

    private CommandLine buildCommandLine(String[] args) throws ParseException {
        return new PosixParser().parse(this.buildOptions(), args);
    }

    private void execute(String[] args) throws Throwable {
        this.route(this.buildCommandLine(args));
    }

    private void route(CommandLine commandLine) throws Throwable {
        Options options = this.buildOptions();
        if (commandLine.hasOption(HELP)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(128);
            formatter.printHelp(" ", options);
            System.exit(0);
        }
        this.initializeAndLaunch(commandLine);
    }

    private void initializeAndLaunch(CommandLine commandLine) throws Throwable {
        LOG.info("### YASMEEN {} v{} : DWCA to {} reference data converter for species data", new Object[]{DWCAConverter.class.getSimpleName(), VERSION, ".taf.gz"});
        boolean sourceIsFile = false;
        String outputDir = commandLine.getOptionValue(OUTPUT_DIR);
        String inputFile = commandLine.getOptionValue(INPUT_FILE);
        String providerId = commandLine.getOptionValue(PROVIDER_ID);
        AssertionUtils.$nNull(inputFile, "Please provide a valid DWCA reference with the -{} option", INPUT_FILE);
        AssertionUtils.$nNull(providerId, "Please provide a valid provider ID with the -{} option", PROVIDER_ID);
        inputFile = inputFile.replace("{providerId}", providerId);
        File originalInputFile = new File(inputFile);
        sourceIsFile = originalInputFile.isFile();
        if (sourceIsFile) {
            LOG.info("Analyzing DWCA file content...");
            File tempFolder = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "DWCA_" + System.currentTimeMillis());
            tempFolder.deleteOnExit();
            tempFolder.mkdir();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            int len = -1;
            FileInputStream is = new FileInputStream(inputFile);
            while ((len = ((InputStream)is).read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            ((InputStream)is).close();
            baos.flush();
            baos.close();
            byte[] zipped = baos.toByteArray();
            String[] entries = EncryptionUtils.listEntriesInZippedStream(zipped);
            AssertionUtils.$true(entries.length > 0, "Resource {} is not a zipped file", inputFile);
            LOG.info("Resource {} is a zipped file: attempting to extract its content into a temporary folder before processing...", (Object)inputFile);
            String[] stringArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                LOG.info("Writing unzipped entry {} to {}", (Object)entry, (Object)(String.valueOf(tempFolder.getAbsolutePath()) + File.separator + entry));
                byte[] unzipped = EncryptionUtils.unzipStreamAndGetEntry(zipped, entry);
                File outFile = new File(tempFolder, entry);
                FileOutputStream fos = new FileOutputStream(outFile);
                fos.write(unzipped);
                fos.flush();
                fos.close();
                ++n2;
            }
            inputFile = tempFolder.getAbsolutePath();
        }
        File outDir = null;
        outDir = outputDir != null ? new File(outputDir) : (sourceIsFile ? new File(originalInputFile.getParentFile(), "out") : new File(originalInputFile, "out"));
        File outputFolder = new File(outDir.getAbsolutePath().replace("{providerId}", providerId));
        if (!outputFolder.exists()) {
            outputFolder.mkdirs();
        }
        AssertionUtils.$true(outputFolder.exists(), "Output folder {} does not exist", outDir);
        AssertionUtils.$true(outputFolder.isDirectory(), "Output folder {} is not a directory", outDir);
        File coreFile = new File(outputFolder, String.valueOf(providerId) + "_taxa.taf.gz");
        File extensionsFile = new File(outputFolder, String.valueOf(providerId) + "_vernacular.taf.gz");
        FileOutputStream outCore = new FileOutputStream(coreFile);
        FileOutputStream outExtensions = new FileOutputStream(extensionsFile);
        GZIPOutputStream gzCore = new GZIPOutputStream(outCore);
        GZIPOutputStream gzExtensions = new GZIPOutputStream(outExtensions);
        OutputStreamWriter oswCore = new OutputStreamWriter((OutputStream)gzCore, "UTF-8");
        OutputStreamWriter oswExtensions = new OutputStreamWriter((OutputStream)gzExtensions, "UTF-8");
        PrintWriter pwCore = new PrintWriter(oswCore);
        PrintWriter pwExtensions = new PrintWriter(oswExtensions);
        new DWCAToReferenceDataCSVConverter().convertData(providerId, inputFile, pwCore, pwExtensions);
        pwCore.close();
        pwExtensions.close();
        gzCore.flush();
        outCore.flush();
        gzExtensions.flush();
        outExtensions.flush();
        gzCore.close();
        outCore.close();
        gzExtensions.close();
        outExtensions.close();
        LOG.info("Taxa data have been written to " + coreFile.getAbsolutePath());
        LOG.info("Vernacular name data have been written to " + extensionsFile.getAbsolutePath());
    }

    public static final void main(String[] args) throws Throwable {
        try {
            new DWCAConverter().execute(args);
            System.exit(0);
        }
        catch (ParseException Pe) {
            LOG.error("{}: [ parser error ] : {}", (Object)DWCAConverter.class.getSimpleName(), (Object)Pe.getMessage());
        }
        catch (IllegalArgumentException IAe) {
            LOG.error("{}: [ configuration error ] : {}", (Object)DWCAConverter.class.getSimpleName(), (Object)IAe.getMessage());
        }
        catch (Throwable t) {
            LOG.error("{}: [ unexpected error ] : {}", (Object)DWCAConverter.class.getSimpleName(), (Object)t.getMessage());
        }
        System.exit(-1);
    }
}

