/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.converters.dwca.legacy.asfis;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import org.fao.vrmf.core.helpers.singletons.lang.objects.CollectionsUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;

public class ASFISToDWCAConverter {
    public static final void main(String[] args) throws Throwable {
        String source = args[0];
        String destination = args[1];
        String destinationTaxa = String.valueOf(destination) + "/taxa.txt";
        String destinationVern = String.valueOf(destination) + "/VernacularName.txt";
        FileInputStream is = new FileInputStream(source);
        GZIPInputStream gzis = new GZIPInputStream(is);
        InputStreamReader isr = new InputStreamReader((InputStream)gzis, "UTF-8");
        CSVReader reader = new CSVReader((Reader)isr, '\t', '\"', 1);
        CSVWriter taxaWriter = new CSVWriter((Writer)new FileWriter(destinationTaxa), '\t', '\u0000');
        CSVWriter vernWriter = new CSVWriter((Writer)new FileWriter(destinationVern), '\t', '\u0000');
        for (String[] sourceData : reader.readAll()) {
            int counter = 0;
            String[] taxaData = new String[10];
            String[] vernData = new String[3];
            String curData = StringUtils.rawTrim(sourceData[0]);
            taxaData[counter++] = curData == null ? null : "ISSCAAP:" + curData;
            curData = StringUtils.rawTrim(sourceData[1]);
            taxaData[counter++] = curData == null ? null : "TAXOCODE:" + curData;
            curData = StringUtils.rawTrim(sourceData[2]);
            taxaData[counter++] = curData == null ? null : "3AC:" + curData;
            taxaData[counter++] = curData == null ? null : "URN:org:fao:fi:asfis:a3c:" + curData;
            taxaData[counter++] = StringUtils.rawTrim(sourceData[3]);
            taxaData[counter++] = StringUtils.rawTrim(sourceData[7]);
            taxaData[counter++] = StringUtils.rawTrim(sourceData[9]);
            taxaData[counter++] = StringUtils.rawTrim(sourceData[8]);
            if (taxaData[4] != null) {
                String[] parts = taxaData[4].split("\\s");
                taxaData[counter++] = StringUtils.rawTrim(parts[0]);
                taxaData[counter++] = CollectionsUtils.join(CollectionsUtils.behead(parts), " ");
            }
            taxaWriter.writeNext(taxaData);
            curData = StringUtils.rawTrim(sourceData[4]);
            if (curData != null) {
                vernData[0] = taxaData[2];
                vernData[1] = curData;
                vernData[2] = "English";
                vernWriter.writeNext(vernData);
            }
            if ((curData = StringUtils.rawTrim(sourceData[5])) != null) {
                vernData[0] = taxaData[2];
                vernData[1] = curData;
                vernData[2] = "French";
                vernWriter.writeNext(vernData);
            }
            if ((curData = StringUtils.rawTrim(sourceData[6])) == null) continue;
            vernData[0] = taxaData[2];
            vernData[1] = curData;
            vernData[2] = "Spanish";
            vernWriter.writeNext(vernData);
        }
        taxaWriter.checkError();
        taxaWriter.flush();
        taxaWriter.close();
        vernWriter.checkError();
        vernWriter.flush();
        vernWriter.close();
        ((InputStream)is).close();
        ((InputStream)gzis).close();
        ((Reader)isr).close();
        reader.close();
    }
}

