/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.converters.dwca.legacy.obis;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import org.fao.vrmf.core.helpers.singletons.lang.objects.CollectionsUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;

public class OBISToDWCAConverter {
    public static final void main(String[] args) throws Throwable {
        String[] sourceData;
        String source = args[0];
        String destination = args[1];
        String destinationTaxa = String.valueOf(destination) + "/taxa.txt";
        String destinationVern = String.valueOf(destination) + "/VernacularName.txt";
        FileInputStream is = new FileInputStream(source);
        GZIPInputStream gzis = new GZIPInputStream(is);
        InputStreamReader isr = new InputStreamReader((InputStream)gzis, "UTF-8");
        CSVReader reader = new CSVReader((Reader)isr, '\t', '\u0000');
        CSVWriter taxaWriter = new CSVWriter((Writer)new FileWriter(destinationTaxa), '\t', '\u0000');
        CSVWriter vernWriter = new CSVWriter((Writer)new FileWriter(destinationVern), '\t', '\u0000');
        while ((sourceData = reader.readNext()) != null) {
            String[] taxaData = new String[6];
            String curData = StringUtils.rawTrim(sourceData[0]);
            taxaData[0] = curData == null ? null : "OBIS:" + curData;
            taxaData[1] = curData == null ? null : "URN:org:iobis:" + curData;
            curData = StringUtils.rawTrim(sourceData[1]);
            String string = taxaData[2] = curData == null ? null : curData;
            if (taxaData[2] != null) {
                String[] parts = taxaData[2].split("\\s");
                taxaData[4] = StringUtils.rawTrim(parts[0]);
                taxaData[5] = CollectionsUtils.join(CollectionsUtils.behead(parts), " ");
            }
            if ((curData = StringUtils.rawTrim(sourceData[2])) != null && !"(null)".equals(curData)) {
                taxaData[3] = curData;
            }
            taxaWriter.writeNext(taxaData);
        }
        taxaWriter.checkError();
        taxaWriter.flush();
        taxaWriter.close();
        vernWriter.checkError();
        vernWriter.flush();
        vernWriter.close();
        ((InputStream)is).close();
        ((InputStream)gzis).close();
        ((Reader)isr).close();
        reader.close();
    }
}

