/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.io.readers;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.fao.fi.comet.domain.species.CommonReferenceSpeciesFactory;
import org.fao.fi.comet.domain.species.InputSpeciesFactory;
import org.fao.fi.comet.domain.species.model.InputSpeciesData;
import org.fao.fi.comet.domain.species.tools.io.readers.CSVFileReader;
import org.fao.vrmf.core.helpers.singletons.lang.objects.CollectionsUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.fao.vrmf.core.tools.lexical.processors.LexicalProcessor;
import org.fao.vrmf.core.tools.lexical.soundex.PhraseSoundexGenerator;
import org.fao.vrmf.core.tools.lexical.soundex.SoundexGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedInputDataFileReader
extends CSVFileReader {
    public static final String[] PARSED_INPUT_DATA_FILE_COLUMNS = new String[]{"PARSER", "INPUT_DATA_SOURCE_ID", "INPUT_DATA_ID", "INPUT_DATA", "PREPARSED_INPUT_DATA", "PARSED_SCIENTIFIC_NAME", "PARSED_AUTHORITY", "POST_PARSED_SCIENTIFIC_NAME", "POST_PARSED_AUTHORITY"};
    public static final String PARSED_INPUT_DATA_FILE_HEADER = CollectionsUtils.join(PARSED_INPUT_DATA_FILE_COLUMNS, ";");
    private static int PARSER_INDEX = 0;
    private static int DATA_SOURCE_INDEX = 1;
    private static int DATA_ID_INDEX = 2;
    private static int INPUT_DATA_INDEX = 3;
    private static int PREPARSED_INPUT_DATA_INDEX = 4;
    private static int PARSED_SCI_NAME_INDEX = 5;
    private static int PARSED_AUTHORITY_INDEX = 6;
    private static int POST_PARSED_SCI_NAME_INDEX = 7;
    private static int POST_PARSED_AUTHORITY_INDEX = 8;
    private static Logger LOG = LoggerFactory.getLogger(ParsedInputDataFileReader.class);

    public InputSpeciesData[] readData(File input, LexicalProcessor speciesSimplifierProcessor, LexicalProcessor speciesNormalizerProcessor, LexicalProcessor authoritiesSimplifierProcessor, LexicalProcessor authoritiesNormalizerProcessor, PhraseSoundexGenerator phraseSoundexer, SoundexGenerator soundexer) throws Throwable {
        return this.readData(input, Boolean.TRUE, speciesSimplifierProcessor, speciesNormalizerProcessor, authoritiesSimplifierProcessor, authoritiesNormalizerProcessor, phraseSoundexer, soundexer);
    }

    public InputSpeciesData[] readData(File input, Boolean skipHeader, LexicalProcessor speciesSimplifierProcessor, LexicalProcessor speciesNormalizerProcessor, LexicalProcessor authoritiesSimplifierProcessor, LexicalProcessor authoritiesNormalizerProcessor, PhraseSoundexGenerator phraseSoundexer, SoundexGenerator soundexer) throws Throwable {
        return this.readData(input, ';', '\"', skipHeader, speciesSimplifierProcessor, speciesNormalizerProcessor, authoritiesSimplifierProcessor, authoritiesNormalizerProcessor, phraseSoundexer, soundexer);
    }

    public InputSpeciesData[] readData(File input) throws Throwable {
        return this.readData(input, Boolean.TRUE, null, null, null, null, null, null);
    }

    public InputSpeciesData[] readData(File input, Boolean skipHeader) throws Throwable {
        return this.readData(input, skipHeader, null, null, null, null, null, null);
    }

    public InputSpeciesData[] readData(File input, char separator, char quote, boolean skipHeader, LexicalProcessor speciesSimplifierProcessor, LexicalProcessor speciesNormalizerProcessor, LexicalProcessor authoritiesSimplifierProcessor, LexicalProcessor authoritiesNormalizerProcessor, PhraseSoundexGenerator phraseSoundexer, SoundexGenerator soundexer) throws Throwable {
        FileInputStream is = new FileInputStream(input);
        InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");
        CSVReader reader = new CSVReader((Reader)isr, separator, quote, skipHeader ? 1 : 0);
        int numLines = 0;
        ArrayList<InputSpeciesData> inputData = new ArrayList<InputSpeciesData>();
        try {
            try {
                String[] data;
                while ((data = reader.readNext()) != null) {
                    ++numLines;
                    InputSpeciesData refData = CommonReferenceSpeciesFactory.updateComplexNames(InputSpeciesFactory.newInstance(data[DATA_SOURCE_INDEX], data[DATA_ID_INDEX], data[INPUT_DATA_INDEX], data[PREPARSED_INPUT_DATA_INDEX], data[PARSED_SCI_NAME_INDEX], data[PARSED_AUTHORITY_INDEX], data[POST_PARSED_SCI_NAME_INDEX], data[POST_PARSED_AUTHORITY_INDEX], data[PARSER_INDEX]), speciesSimplifierProcessor, speciesNormalizerProcessor, authoritiesSimplifierProcessor, authoritiesNormalizerProcessor, phraseSoundexer, soundexer);
                    if (StringUtils.rawTrim(refData.getScientificName()) == null) continue;
                    inputData.add(refData);
                }
            }
            catch (ArrayIndexOutOfBoundsException AIOOBe) {
                throw new RuntimeException("File " + input.getAbsolutePath() + " is not in the expected Parsed Data format");
            }
        }
        finally {
            reader.close();
            isr.close();
            ((InputStream)is).close();
        }
        LOG.info("Read {} non-empty species data from {} lines in {}", new Object[]{inputData.size(), numLines, input.getAbsolutePath()});
        return inputData.toArray(new InputSpeciesData[inputData.size()]);
    }
}

