/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.io.readers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import org.fao.fi.comet.core.model.common.LinkedTypedComplexName;
import org.fao.fi.comet.domain.species.model.SpeciesData;
import org.fao.fi.comet.domain.species.tools.io.readers.ParsedInputDataFileReader;
import org.fao.fi.comet.domain.species.tools.io.support.ReferenceDataConverter;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceDataFileReader<SPECIES_MODEL extends SpeciesData> {
    private static Logger LOG = LoggerFactory.getLogger(ParsedInputDataFileReader.class);

    public Collection<LinkedTypedComplexName> readVernacularData(InputStream inputStream, String providerId, char separator, char quote, boolean skipHeader, ReferenceDataConverter<SPECIES_MODEL> converter) throws IOException {
        GZIPInputStream gzis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            gzis = new GZIPInputStream(inputStream);
            isr = new InputStreamReader((InputStream)gzis, "UTF-8");
            br = new BufferedReader(isr);
            ArrayList<LinkedTypedComplexName> vernacularNames = new ArrayList<LinkedTypedComplexName>();
            int numLines = 0;
            while ((line = br.readLine()) != null) {
                LinkedTypedComplexName vernacularCName;
                if (skipHeader && ++numLines == 1 || (line = StringUtils.rawTrim(line)) == null || (vernacularCName = converter.deserializeVernacularCName(providerId, line)) == null || vernacularCName.isEmpty()) continue;
                vernacularNames.add(vernacularCName);
            }
            LOG.info("Read {} non-empty vernacular names data from {} lines served by provided input stream", (Object)vernacularNames.size(), (Object)numLines);
            ArrayList<LinkedTypedComplexName> arrayList = vernacularNames;
            return arrayList;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Throwable t) {
                    LOG.warn("Unable to close buffered reader: {}", (Object)t.getMessage());
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Throwable t) {
                    LOG.warn("Unable to close input stream reader: {}", (Object)t.getMessage());
                }
            }
            if (gzis != null) {
                try {
                    gzis.close();
                }
                catch (Throwable t) {
                    LOG.warn("Unable to close GZIP input stream: {}", (Object)t.getMessage());
                }
            }
        }
    }

    public Collection<SPECIES_MODEL> readTaxaData(InputStream inputStream, String providerId, char separator, char quote, boolean skipHeader, ReferenceDataConverter<SPECIES_MODEL> converter) throws IOException {
        GZIPInputStream gzis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            gzis = new GZIPInputStream(inputStream);
            isr = new InputStreamReader((InputStream)gzis, "UTF-8");
            br = new BufferedReader(isr);
            ArrayList<SPECIES_MODEL> taxaData = new ArrayList<SPECIES_MODEL>();
            int numLines = 0;
            while ((line = br.readLine()) != null) {
                SPECIES_MODEL referenceData;
                if (skipHeader && ++numLines == 1 || (line = StringUtils.rawTrim(line)) == null || (referenceData = converter.deserializeTaxa(providerId, line)) == null) continue;
                taxaData.add(referenceData);
            }
            LOG.info("Read {} non-empty reference species data from {} lines served by provided input stream", (Object)taxaData.size(), (Object)numLines);
            ArrayList<SPECIES_MODEL> arrayList = taxaData;
            return arrayList;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Throwable t) {
                    LOG.warn("Unable to close buffered reader: {}", (Object)t.getMessage());
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Throwable t) {
                    LOG.warn("Unable to close input stream reader: {}", (Object)t.getMessage());
                }
            }
            if (gzis != null) {
                try {
                    gzis.close();
                }
                catch (Throwable t) {
                    LOG.warn("Unable to close GZIP input stream: {}", (Object)t.getMessage());
                }
            }
        }
    }
}

