/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.io.writers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTextFileWriter {
    protected static Logger LOG = LoggerFactory.getLogger(BasicTextFileWriter.class);
    public static boolean SKIP_EMPTY_LINES = true;
    public static boolean KEEP_EMPTY_LINES = !SKIP_EMPTY_LINES;

    public void writeLines(File output, String[] lines, boolean emptyLines) throws IOException {
        FileOutputStream os = new FileOutputStream(output);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
        PrintWriter pw = new PrintWriter(osw);
        int numNonEmptyLines = 0;
        int numLines = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (StringUtils.rawTrim(line) == null) {
                if (emptyLines == KEEP_EMPTY_LINES) {
                    pw.println(ObjectsUtils.coalesce(line, ""));
                }
            } else {
                pw.println(line);
                ++numNonEmptyLines;
            }
            ++numLines;
            ++n2;
        }
        os.flush();
        osw.flush();
        pw.flush();
        ((OutputStream)os).close();
        osw.close();
        pw.close();
        LOG.info("Wrote {} non empty lines out of {} total lines in {}", new Object[]{numNonEmptyLines, numLines, output.getAbsolutePath()});
    }

    public void write(File output, String content, boolean emptyLines) throws IOException {
        if (content == null) {
            if (!output.exists()) {
                output.createNewFile();
            }
        } else {
            this.writeLines(output, content.split("\\n", -1), emptyLines);
        }
    }
}

