/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.lexical.processors.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.fao.vrmf.core.tools.lexical.processors.AbstractLexicalProcessor;

public class SpeciesNormalizerProcessor
extends AbstractLexicalProcessor {
    private static final Pattern IG_PATTERN = Pattern.compile("(.*)(IG)(ER|RA|ROS|RUM|RUS)$", 2);
    private static final Pattern SUFFIX_2_PATTERN = Pattern.compile("(.*)(AE|AK|AM|AR|AS|AX|EA|ES|EX|II|IS|IX|NS|OK|ON|OR|OS|OX|UM|US|YS|YX)$", 2);
    private static final Pattern SUFFIX_1_PATTERN = Pattern.compile("(.*)(A|E|I|O|U|Y)$", 2);

    @Override
    protected String doProcess(String toProcess) {
        if ((toProcess = StringUtils.rawTrim(toProcess)) == null) {
            return null;
        }
        Matcher IG_MATCHER = IG_PATTERN.matcher(toProcess);
        if (IG_MATCHER.matches()) {
            return String.valueOf(IG_MATCHER.group(1)) + IG_MATCHER.group(2);
        }
        Matcher SUFFIX_2_MATCHER = SUFFIX_2_PATTERN.matcher(toProcess);
        if (SUFFIX_2_MATCHER.matches()) {
            return SUFFIX_2_MATCHER.group(1);
        }
        Matcher SUFFIX_1_MATCHER = SUFFIX_1_PATTERN.matcher(toProcess);
        if (SUFFIX_1_MATCHER.matches()) {
            return SUFFIX_1_MATCHER.group(1);
        }
        return toProcess;
    }
}

