/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.extras.matchlets.common;

import java.io.Serializable;
import org.fao.fi.comet.core.matchlets.skeleton.ScalarMatchletSkeleton;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletDefaultSerializationExclusionPolicy;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.vrmf.core.behaviours.data.Identifiable;

@MatchletDefaultSerializationExclusionPolicy
public class IdentityMatchlet<SOURCE extends Identifiable<SOURCE_DATA>, SOURCE_DATA extends Serializable, TARGET extends Identifiable<TARGET_DATA>, TARGET_DATA extends Serializable>
extends ScalarMatchletSkeleton<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> {
    private static final long serialVersionUID = -4220739817539555026L;

    public IdentityMatchlet() {
        this._name = "IdentityMatchlet";
    }

    @Override
    public String getDescription() {
        return "Matches entity identifiers as extracted from a pair of input / reference matched entities. Returns an AUTHORITATIVE NO MATCH if the two identifiers being compared are the same, and a NON PERFORMED result if they differ. This matchlet has mainly the purpose to avoid that two entities of the same type AND with the same ID are compared, as they are indeed expected to represent the same data.";
    }

    @Override
    public SOURCE_DATA extractSourceData(SOURCE source, DataIdentifier sourceIdentifier) {
        return (SOURCE_DATA)source.getId();
    }

    @Override
    public TARGET_DATA extractTargetData(TARGET target, DataIdentifier sourceIdentifier) {
        return (TARGET_DATA)target.getId();
    }

    @Override
    public MatchingScore computeScore(SOURCE source, DataIdentifier sourceIdentifier, SOURCE_DATA sourceData, TARGET target, DataIdentifier targetIdentifier, TARGET_DATA targetData) {
        String targetProviderId;
        String sourceProviderId = sourceIdentifier.getProviderId();
        if (sourceProviderId.equals(targetProviderId = targetIdentifier.getProviderId()) && sourceData.equals(targetData)) {
            return MatchingScore.getAuthoritativeNoMatchTemplate();
        }
        return MatchingScore.getNonPerformedTemplate();
    }
}

