/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.extras.matchlets.common.behaviours;

import java.io.Serializable;
import org.fao.fi.comet.core.matchlets.skeleton.behaviours.BasicBehaviour;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.extras.matchlets.helpers.TimeDistanceHelper;
import org.fao.vrmf.core.behaviours.data.DateReferenced;
import org.fao.vrmf.core.extensions.date.TimeResolutionUnit;

public class TimeDistanceAwareBehaviour<SOURCE extends Serializable, SOURCE_DATA extends DateReferenced, TARGET extends Serializable, TARGET_DATA extends DateReferenced>
extends BasicBehaviour<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> {
    private static final long serialVersionUID = -8218136145191518357L;
    private final long _absoluteMaximumTimeDistance;
    private final TimeResolutionUnit _timeResolutionUnit;
    private final TimeDistanceHelper _timeHelper = new TimeDistanceHelper();

    public TimeDistanceAwareBehaviour(long absoluteMaximumTimeDistance, TimeResolutionUnit timeResolutionUnit) {
        assert (timeResolutionUnit != null) : "Provided time resolution unit cannot be null";
        assert (Double.compare(absoluteMaximumTimeDistance, 0.0) > 0) : "The absolute maximum time distance cannot be zero or lower (currently: " + absoluteMaximumTimeDistance + ")";
        this._absoluteMaximumTimeDistance = absoluteMaximumTimeDistance;
        this._timeResolutionUnit = timeResolutionUnit;
    }

    @Override
    protected MatchingScore doUpdateScore(MatchingScore current, SOURCE_DATA sourceData, TARGET_DATA targetData) {
        MatchingScore updated = new MatchingScore(current);
        Long timeDistance = this._timeHelper.getTimeDistance(sourceData.getReferenceDate(), targetData.getReferenceDate(), this._timeResolutionUnit);
        if (timeDistance == null || timeDistance > this._absoluteMaximumTimeDistance) {
            updated = MatchingScore.getNonAuthoritativeNoMatchTemplate();
        } else {
            double relativeDistance = (double)timeDistance.longValue() * 1.0 / (double)this._absoluteMaximumTimeDistance;
            updated.setValue(updated.getValue() * (1.0 - relativeDistance));
        }
        return updated;
    }
}

