/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.extras.matchlets.helpers;

import org.fao.fi.comet.core.matchlets.skeleton.helpers.StringComparisonHelperSkeleton;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.vrmf.core.behaviours.data.SimplifiedNameAware;

public final class SimpleNameHelper<DATA extends SimplifiedNameAware>
extends StringComparisonHelperSkeleton {
    private static final long serialVersionUID = -5095522091352365846L;

    public MatchingScore computeScore(double simplifiedNameWeight, DATA firstData, DATA secondData) {
        assert (Double.compare(simplifiedNameWeight, 0.0) >= 0) : "The simplified name weight cannot be lower than zero";
        assert (Double.compare(simplifiedNameWeight, 1.0) <= 0) : "The simplified name weight cannot be greater than one";
        String firstName = firstData.getName();
        String secondName = secondData.getName();
        String simplifiedFirstName = firstData.getSimplifiedName();
        String simplifiedSecondName = secondData.getSimplifiedName();
        if (firstName == null && secondName == null) {
            return MatchingScore.getNonPerformedTemplate();
        }
        if (firstName == null || secondName == null) {
            return MatchingScore.getNonAuthoritativeNoMatchTemplate();
        }
        assert (simplifiedFirstName != null || simplifiedSecondName != null) : "A non-null name should not lead to a null simplified name";
        if (firstName.trim().equalsIgnoreCase(secondName.trim())) {
            return MatchingScore.getNonAuthoritativeFullMatchTemplate();
        }
        return super.compareStrings(simplifiedNameWeight, true, true, simplifiedFirstName, simplifiedSecondName);
    }
}

