/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.extras.matchlets.skeleton;

import java.io.Serializable;
import org.fao.fi.comet.core.matchlets.skeleton.MatchletSkeleton;
import org.fao.fi.comet.core.matchlets.skeleton.behaviours.BehaviourSkeleton;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletMetadata;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.core.model.support.MatchingType;
import org.fao.vrmf.core.behaviours.data.SimplifiedNameAware;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;

public abstract class SimpleNameMatchletSkeleton<SOURCE extends Serializable, SOURCE_DATA extends SimplifiedNameAware, TARGET extends Serializable, TARGET_DATA extends SimplifiedNameAware>
extends MatchletSkeleton<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> {
    private static final long serialVersionUID = -5051549998242880045L;
    @MatchletMetadata
    protected double _simplifiedNameWeight = 0.7;

    public SimpleNameMatchletSkeleton() {
    }

    public SimpleNameMatchletSkeleton(double simplifiedNameWeight) {
        this._simplifiedNameWeight = simplifiedNameWeight;
    }

    public SimpleNameMatchletSkeleton(BehaviourSkeleton<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> behaviour) {
        super(behaviour);
    }

    public SimpleNameMatchletSkeleton(BehaviourSkeleton<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> behaviour, double simplifiedNameWeight) {
        super(behaviour);
        assert (Double.compare(simplifiedNameWeight, 0.0) >= 0);
        this._simplifiedNameWeight = simplifiedNameWeight;
    }

    @Override
    public MatchingScore computeScore(SOURCE source, DataIdentifier sourceIdentifier, SOURCE_DATA sourceData, TARGET target, DataIdentifier targetIdentifier, TARGET_DATA targetData) {
        String sourceName = StringUtils.rawTrim(sourceData.getName());
        String targetName = StringUtils.rawTrim(targetData.getName());
        String simplifiedSourceName = StringUtils.rawTrim(sourceData.getSimplifiedName());
        String simplifiedTargetName = StringUtils.rawTrim(targetData.getSimplifiedName());
        if (sourceName == null && targetName == null) {
            return MatchingScore.getNonPerformedTemplate();
        }
        if (sourceName == null || targetName == null) {
            return MatchingScore.getNonAuthoritativeNoMatchTemplate();
        }
        if (sourceName.trim().equalsIgnoreCase(targetName.trim())) {
            return MatchingScore.getNonAuthoritativeFullMatchTemplate();
        }
        if (simplifiedSourceName == null && simplifiedTargetName == null) {
            return MatchingScore.getNonPerformedTemplate();
        }
        if (simplifiedSourceName == null || simplifiedTargetName == null) {
            return MatchingScore.getNonAuthoritativeNoMatchTemplate();
        }
        double lambda = 0.0;
        lambda = simplifiedSourceName.trim().equalsIgnoreCase(simplifiedTargetName) ? 1.0 : StringUtils.computeRelativeDistance(simplifiedSourceName.toUpperCase(), simplifiedTargetName.toUpperCase());
        return new MatchingScore(this._simplifiedNameWeight * lambda, MatchingType.NON_AUTHORITATIVE);
    }
}

