/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.extras.matchlets.skeleton.historical;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.fao.fi.comet.core.matchlets.skeleton.MatchletSkeleton;
import org.fao.fi.comet.core.matchlets.skeleton.behaviours.BasicBehaviour;
import org.fao.fi.comet.core.matchlets.skeleton.behaviours.BehaviourSkeleton;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.engine.MatchingResult;
import org.fao.fi.comet.core.model.engine.MatchingResultData;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.extras.matchlets.HistoricalDataMatchlet;
import org.fao.vrmf.core.behaviours.data.DateReferenced;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;

public abstract class HistoricalMatchletSkeleton<SOURCE extends Serializable, SOURCE_DATA extends DateReferenced, TARGET extends Serializable, TARGET_DATA extends DateReferenced>
extends MatchletSkeleton<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA>
implements HistoricalDataMatchlet<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> {
    private static final long serialVersionUID = -2794121500041289312L;

    public HistoricalMatchletSkeleton() {
        this(new BasicBehaviour());
    }

    public HistoricalMatchletSkeleton(BehaviourSkeleton<SOURCE, SOURCE_DATA, TARGET, TARGET_DATA> behaviour) {
        super(behaviour);
    }

    @Override
    public MatchingResult<SOURCE_DATA, TARGET_DATA> compareData(SOURCE source, DataIdentifier sourceIdentifier, TARGET target, DataIdentifier targetIdentifier) {
        AssertionUtils.$nNull(source, "Source cannot be null", new Object[0]);
        AssertionUtils.$nNull(sourceIdentifier, "Source identifier cannot be null", new Object[0]);
        AssertionUtils.$nNull(target, "Target cannot be null", new Object[0]);
        AssertionUtils.$nNull(targetIdentifier, "Target identifier cannot be null", new Object[0]);
        Collection sourceData = this.extractSourceData(source, sourceIdentifier);
        Collection targetData = this.extractTargetData(target, targetIdentifier);
        boolean noSourceData = sourceData == null;
        boolean noTargetData = targetData == null;
        boolean emptySourceData = noSourceData || sourceData.isEmpty();
        boolean emptyTargetData = noTargetData || targetData.isEmpty();
        boolean dontPerformMatching = noSourceData && noTargetData;
        boolean assertNoMatch = emptySourceData || emptyTargetData;
        MatchingResult<Object, Object> result = this.newMatchingResult();
        if (dontPerformMatching) {
            result.setScore(MatchingScore.getNonPerformedTemplate());
            return result;
        }
        if (!assertNoMatch) {
            MatchingResult<DateReferenced, DateReferenced> temporaryResult = null;
            MatchingScore currentScore = null;
            for (DateReferenced currentSourceData : sourceData) {
                Iterator iterator = targetData.iterator();
                while (iterator.hasNext()) {
                    DateReferenced currentTargetData;
                    currentScore = currentSourceData == null && currentTargetData == null ? MatchingScore.getNonPerformedTemplate() : (currentSourceData == null || currentTargetData == null ? MatchingScore.getNonAuthoritativeNoMatchTemplate() : this._behaviour.updateScore(this.computeScore(source, sourceIdentifier, currentSourceData, target, targetIdentifier, currentTargetData), source, currentSourceData, target, currentTargetData));
                    temporaryResult = this.updateResult(new MatchingResult(this), currentScore, currentSourceData, sourceIdentifier, currentTargetData = (DateReferenced)iterator.next());
                    if (temporaryResult.isAuthoritative()) {
                        return temporaryResult;
                    }
                    if (temporaryResult.isNonPerformed()) continue;
                    if (Double.compare(temporaryResult.getScore().getValue(), result.getScore().getValue()) > 0) {
                        result = temporaryResult;
                        continue;
                    }
                    if (Double.compare(temporaryResult.getScore().getValue(), result.getScore().getValue()) != 0) continue;
                    MatchingResultData<Object, Object> matching = null;
                    if (result.containsMatchingFor(currentSourceData, sourceIdentifier) && currentTargetData != null) {
                        matching = result.getMatchingsResultDataFor(currentSourceData, sourceIdentifier);
                        matching.getMatchingTargetData().add(currentTargetData);
                    } else {
                        result.getMatchingsResultData().addAll(temporaryResult.getMatchingsResultData());
                    }
                    result.getScore().setMatchingType(temporaryResult.getScore().getMatchingType());
                }
            }
            return result;
        }
        if (this.isOptional()) {
            result.setScore(MatchingScore.getNonPerformedTemplate());
        } else {
            result.setScore(MatchingScore.getNonAuthoritativeNoMatchTemplate());
        }
        return result;
    }
}

