/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.behaviours.design.patterns.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.fao.vrmf.core.behaviours.design.patterns.cache.CacheEntryUpdaterAction;
import org.fao.vrmf.core.behaviours.design.patterns.cache.CacheInfo;
import org.fao.vrmf.core.behaviours.design.patterns.cache.CacheListener;
import org.fao.vrmf.core.behaviours.design.patterns.cache.exceptions.KeyAlreadyMappedException;
import org.fao.vrmf.core.behaviours.design.patterns.cache.exceptions.KeyIsNotMappedException;
import org.fao.vrmf.core.behaviours.design.patterns.cache.exceptions.OperationUnavailableException;
import org.fao.vrmf.core.behaviours.design.patterns.factory.FactoryProvidedObject;

public interface CacheFacade<K, V>
extends FactoryProvidedObject {
    public String getCacheID();

    public String getCacheUID();

    public boolean providesPerEntryTimeout();

    public boolean providesGlobalTimeout();

    public boolean requiresExplicitKeySynchronization();

    public Object getBackingCache() throws OperationUnavailableException;

    public int size();

    public int exactSize();

    public Map<K, V> getAsMap() throws OperationUnavailableException;

    public void addCacheListener(CacheListener<K, V> var1);

    public void removeCacheListener(CacheListener<K, V> var1);

    public void enableListeners();

    public void disableListeners();

    public boolean areListenersEnabled();

    public boolean containsKey(K var1);

    public Set<K> keySet();

    public Collection<V> entries();

    public void clear();

    public V safeGet(K var1) throws KeyIsNotMappedException;

    public V get(K var1);

    public void safePut(K var1, V var2) throws KeyAlreadyMappedException;

    public void safePut(K var1, V var2, long var3) throws KeyAlreadyMappedException;

    public void safePut(K var1, V var2, CacheEntryValidity var3) throws KeyAlreadyMappedException;

    public V put(K var1, V var2);

    public V put(K var1, V var2, long var3);

    public V put(K var1, V var2, CacheEntryValidity var3);

    public V safeRemove(K var1) throws KeyIsNotMappedException;

    public V remove(K var1);

    public void atomicUpdate(K var1, V var2, CacheEntryUpdaterAction<V> var3) throws KeyIsNotMappedException;

    public CacheInfo<K, V> getCacheInfo();

    public static enum CacheEntryValidity {
        ZERO(0L),
        ONE_SECOND(1000L),
        ONE_MINUTE(60L * ONE_SECOND.getValidity()),
        TEN_MINUTES(10L * ONE_MINUTE.getValidity()),
        HALF_HOUR(3L * TEN_MINUTES.getValidity()),
        ONE_HOUR(2L * HALF_HOUR.getValidity()),
        ONE_DAY(24L * ONE_HOUR.getValidity()),
        ETERNAL(Long.MAX_VALUE);

        private long _validity;

        private CacheEntryValidity(long validity) {
            this._validity = validity;
        }

        public long getValidity() {
            return this._validity;
        }
    }
}

