/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.extensions.collections.nu.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.fao.vrmf.core.behaviours.design.patterns.predicate.Action;
import org.fao.vrmf.core.behaviours.design.patterns.predicate.Predicate;
import org.fao.vrmf.core.extensions.collections.impl.ListSet;
import org.fao.vrmf.core.extensions.collections.nu.NuList;
import org.fao.vrmf.core.extensions.collections.nu.NuSet;
import org.fao.vrmf.core.impl.design.patterns.predicate.AlwaysTruePredicate;

public class NuListSet<ENTRY>
extends ListSet<ENTRY>
implements NuSet<ENTRY>,
NuList<ENTRY> {
    private static final long serialVersionUID = -3069942974043413809L;

    public NuListSet() {
    }

    public NuListSet(ENTRY[] items) {
        this((Collection<ENTRY>)Arrays.asList(items));
    }

    public NuListSet(Collection<ENTRY> items) {
        this();
        this.addAll(items);
    }

    @Override
    public ENTRY first() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (ENTRY)this.get(0);
    }

    @Override
    public ENTRY last() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (ENTRY)this.get(this.size() - 1);
    }

    @Override
    public final NuListSet<ENTRY> select(Predicate<ENTRY> predicate) {
        assert (predicate != null) : "Predicate cannot be NULL";
        NuListSet selected = new NuListSet();
        for (Object current : this) {
            if (!predicate.is(current)) continue;
            selected.add(current);
        }
        return selected;
    }

    @Override
    public final NuListSet<ENTRY> selectOthers(Predicate<ENTRY> predicate) {
        assert (predicate != null) : "Predicate cannot be NULL";
        NuListSet selected = new NuListSet();
        for (Object current : this) {
            if (!predicate.isNot(current)) continue;
            selected.add(current);
        }
        return selected;
    }

    @Override
    public final void forEachDo(Action<ENTRY> action) {
        assert (action != null) : "Action cannot be NULL";
        this.forEachSelectedDo(new AlwaysTruePredicate(), action);
    }

    @Override
    public final void forEachSelectedDo(Predicate<ENTRY> predicate, Action<ENTRY> action) {
        assert (predicate != null) : "Predicate cannot be NULL";
        assert (action != null) : "Action cannot be NULL";
        for (Object current : this) {
            if (!predicate.is(current)) continue;
            action.perform(current);
        }
    }

    @Override
    public final void forEachOtherDo(Predicate<ENTRY> predicate, Action<ENTRY> action) {
        assert (predicate != null) : "Predicate cannot be NULL";
        assert (action != null) : "Action cannot be NULL";
        for (Object current : this) {
            if (!predicate.isNot(current)) continue;
            action.perform(current);
        }
    }

    @Override
    public final NuListSet<ENTRY> intersect(final NuSet<ENTRY> other) {
        final NuListSet<ENTRY> intersection = new NuListSet<ENTRY>();
        this.forEachDo(new Action<ENTRY>(){

            @Override
            public void perform(ENTRY subject) {
                if (other.contains(subject)) {
                    intersection.add(subject);
                }
            }
        });
        return intersection;
    }

    @Override
    public final NuListSet<ENTRY> reverseIntersect(final NuSet<ENTRY> other) {
        final NuListSet<ENTRY> intersection = new NuListSet<ENTRY>();
        this.forEachDo(new Action<ENTRY>(){

            @Override
            public void perform(ENTRY subject) {
                if (!other.contains(subject)) {
                    intersection.add(subject);
                }
            }
        });
        return intersection;
    }

    @Override
    public final NuListSet<ENTRY> reverse() {
        NuListSet<ENTRY> reversed = new NuListSet<ENTRY>();
        for (Object current : this) {
            reversed.add(0, current);
        }
        return reversed;
    }
}

