/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.extensions.maps.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.fao.vrmf.core.behaviours.design.patterns.cache.CacheFacade;
import org.fao.vrmf.core.extensions.exceptions.WrappedRuntimeException;
import org.fao.vrmf.core.impl.design.patterns.cache.simple.SimpleCacheFacade;
import org.fao.vrmf.core.impl.logging.ImmutableLoggingClient;

public abstract class LazyMap<KEY, VALUE>
extends ImmutableLoggingClient
implements Map<KEY, VALUE> {
    protected CacheFacade<KEY, VALUE> _backingCache;

    protected abstract int doGetSize() throws Throwable;

    protected abstract VALUE doGetElement(KEY var1) throws Throwable;

    protected abstract Set<KEY> doGetKeySet() throws Throwable;

    public LazyMap() {
        this._log.info("Initializing " + this.getClass().getName() + " @ " + this.hashCode());
        this._backingCache = new SimpleCacheFacade<KEY, VALUE>();
    }

    public LazyMap(CacheFacade<KEY, VALUE> backingCache) {
        this._log.info("Initializing " + this.getClass().getName() + " @ " + this.hashCode() + " with backing cache " + backingCache.getCacheID());
        assert (backingCache != null);
        this._backingCache = backingCache;
    }

    @Override
    public int size() {
        try {
            return this.doGetSize();
        }
        catch (Throwable t) {
            String message = "Unable to get size for lazy map " + this;
            this._log.error(message, t);
            throw new WrappedRuntimeException(message, t);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() > 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public VALUE get(Object key) {
        VALUE current = this._backingCache.get(key);
        if (current == null) {
            this._log.debug("Getting element with key " + key + " from cache " + this._backingCache.getCacheID());
            try {
                current = this.doGetElement(key);
                this._backingCache.put(key, current);
            }
            catch (Throwable t) {
                String message = "Unable to get element with key " + key + " from lazy map " + this;
                this._log.error(message, t);
                throw new WrappedRuntimeException(message, t);
            }
        } else {
            this._log.debug("Element with key " + key + " is already cached by cache " + this._backingCache.getCacheID());
        }
        return current;
    }

    @Override
    public VALUE put(KEY key, VALUE value) {
        return this._backingCache.put(key, value);
    }

    @Override
    public VALUE remove(Object key) {
        return this._backingCache.remove(key);
    }

    @Override
    public void putAll(Map<? extends KEY, ? extends VALUE> m) {
        for (Map.Entry<KEY, VALUE> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this._backingCache.clear();
    }

    @Override
    public Set<KEY> keySet() {
        try {
            return this.doGetKeySet();
        }
        catch (Throwable t) {
            String message = "Unable to get keyset for lazy map " + this;
            this._log.error(message, t);
            throw new WrappedRuntimeException(message, t);
        }
    }

    @Override
    public Collection<VALUE> values() {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public Set<Map.Entry<KEY, VALUE>> entrySet() {
        throw new RuntimeException("Unimplemented");
    }
}

