/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.beans.io.net.support;

import java.io.Serializable;
import java.util.Date;
import org.apache.http.Header;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;

public final class HTTPRequestMetadata
implements Serializable {
    private static final long serialVersionUID = 2361791259305569203L;
    private String _URL;
    private Date _downloadTimestamp;
    private long _downloadTime;
    private int _responseCode;
    private Header[] _headers;
    private byte[] _content;

    public HTTPRequestMetadata() {
    }

    public HTTPRequestMetadata(String uRL, Date downloadTimestamp, long donwloadTime, int responseCode, Header[] headers, byte[] content) {
        this._URL = uRL;
        this._downloadTimestamp = ObjectsUtils.rawClone(downloadTimestamp);
        this._downloadTime = ObjectsUtils.rawClone(donwloadTime);
        this._responseCode = ObjectsUtils.rawClone(responseCode);
        this._headers = ObjectsUtils.rawClone(headers);
        this._content = ObjectsUtils.rawClone(content);
    }

    public String getURL() {
        return this._URL;
    }

    public void setURL(String uRL) {
        this._URL = uRL;
    }

    public Date getDownloadTimestamp() {
        return ObjectsUtils.rawClone(this._downloadTimestamp);
    }

    public void setDownloadTimestamp(Date downloadTimestamp) {
        this._downloadTimestamp = ObjectsUtils.rawClone(downloadTimestamp);
    }

    public long getDownloadTime() {
        return this._downloadTime;
    }

    public void setDownloadTime(long downloadTime) {
        this._downloadTime = downloadTime;
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public void setResponseCode(int responseCode) {
        this._responseCode = responseCode;
    }

    public Header[] getHeaders() {
        return ObjectsUtils.rawClone(this._headers);
    }

    public void setHeaders(Header[] headers) {
        this._headers = ObjectsUtils.rawClone(headers);
    }

    public String getFilename() {
        String contentDisposition;
        if (this._headers != null && (contentDisposition = this.getHeader("Content-Disposition")) != null && contentDisposition.indexOf("filename=") != -1) {
            return contentDisposition.substring(contentDisposition.indexOf("=") + 1);
        }
        return "<UNAVAILABLE>";
    }

    public byte[] getContent() {
        return ObjectsUtils.rawClone(this._content);
    }

    public void setContent(byte[] content) {
        this._content = ObjectsUtils.rawClone(content);
    }

    public int getContentLength() {
        if (this._content != null) {
            return this._content.length;
        }
        return -1;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    private String getHeader(String headerName) {
        assert (headerName != null) : "Header name cannot be null";
        if (this._headers != null) {
            Header[] headerArray = this._headers;
            int n = this._headers.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                if (headerName.equalsIgnoreCase(header.getName())) {
                    return header.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer toReturn = new StringBuffer();
        toReturn.append("URL           : ").append(this._URL).append("\n");
        toReturn.append("Downloaded @  : ").append(this._downloadTimestamp).append("\n");
        toReturn.append("Download time : ").append(this._downloadTime).append(" mSec\n");
        toReturn.append("Response code : ").append(this._responseCode).append("\n");
        if (this._headers != null) {
            toReturn.append("Headers       : ").append("\n");
            Header[] headerArray = this._headers;
            int n = this._headers.length;
            int n2 = 0;
            while (n2 < n) {
                Header h = headerArray[n2];
                toReturn.append("                * ").append(h.getName()).append(": ").append(h.getValue()).append("\n");
                ++n2;
            }
        }
        toReturn.append("File name     : ").append(this.getFilename()).append("\n");
        if (this._content != null) {
            toReturn.append("Content length: ").append(this._content.length).append("\n");
            toReturn.append("Content type  : ").append(this.getContentType()).append("\n");
        }
        return toReturn.toString();
    }
}

