/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.beans.text.xml;

import java.net.URI;
import java.net.URL;
import javax.inject.Named;
import org.apache.commons.lang.StringEscapeUtils;
import org.fao.vrmf.core.helpers.beans.text.xml.XMLPrettyPrinter;
import org.fao.vrmf.core.impl.design.patterns.pair.NameValuePair;

@Named
public final class HTMLPrettyPrinter
extends XMLPrettyPrinter {
    private static final long serialVersionUID = 4707099744775433210L;
    private static final String HTML_DTD_DECLARATION = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";

    public HTMLPrettyPrinter() {
    }

    public HTMLPrettyPrinter(String namespace, URI namespaceURI, URL schemaLocation) {
        super(namespace, namespaceURI, schemaLocation);
    }

    public HTMLPrettyPrinter(String namespace, URI namespaceURI, URL schemaLocation, String padder) {
        super(namespace, namespaceURI, schemaLocation, padder);
    }

    @Override
    public String nil() {
        return "";
    }

    @Override
    public String nil(NameValuePair attribute) {
        return this.nil();
    }

    @Override
    public String nil(NameValuePair ... attributes) {
        return this.nil();
    }

    @Override
    public String open(String tag) {
        StringBuilder result = new StringBuilder();
        if (this._level == 0 && this._includeHeaders) {
            result.append(HTML_DTD_DECLARATION).append("\n");
        }
        result.append(super.open(tag)).toString();
        return result.toString();
    }

    @Override
    public String open(String tag, NameValuePair ... attributes) {
        StringBuilder result = new StringBuilder();
        if (this._level == 0 && this._includeHeaders) {
            result.append(HTML_DTD_DECLARATION).append("\n");
        }
        return result.append(super.open(tag, attributes)).toString();
    }

    @Override
    public String cdata(String content) {
        return this.text(content);
    }

    @Override
    public String text(String content) {
        boolean bl = this._hasContent = content != null;
        if (this._hasContent) {
            return StringEscapeUtils.escapeHtml((String)content);
        }
        return this.nil();
    }
}

