/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.singletons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.fao.vrmf.core.helpers.beans.io.file.FileUtils;
import org.fao.vrmf.core.helpers.singletons.AbstractHelperSingleton;
import org.slf4j.Logger;

public final class EncryptionUtils
extends AbstractHelperSingleton {
    private static final int BUFFER_SIZE = 32768;

    private EncryptionUtils() {
    }

    private static Logger getCustomLog() {
        return AbstractHelperSingleton.getLogger(EncryptionUtils.class);
    }

    public static String getMD5Sum(String content) throws NoSuchAlgorithmException {
        return EncryptionUtils.getMD5Sum(content.getBytes());
    }

    public static String getMD5Sum(File path, String filename) throws IOException, NoSuchAlgorithmException {
        return EncryptionUtils.getMD5Sum(new FileUtils().readFile(path, filename));
    }

    public static String getMD5Sum(byte[] content) throws NoSuchAlgorithmException {
        MessageDigest complete = MessageDigest.getInstance("MD5");
        complete.update(content);
        return EncryptionUtils.convertToHexString(complete.digest());
    }

    public static String getMD5Sum(File file) throws NoSuchAlgorithmException, IOException {
        return EncryptionUtils.getMD5Sum(new FileInputStream(file));
    }

    public static String getMD5Sum(InputStream stream) throws NoSuchAlgorithmException, IOException {
        MessageDigest complete = MessageDigest.getInstance("MD5");
        try {
            new DigestInputStream(stream, complete);
        }
        finally {
            stream.close();
        }
        return EncryptionUtils.convertToHexString(complete.digest());
    }

    public static byte[] unGzipStream(byte[] gZippedStream) throws Throwable {
        EncryptionUtils.getCustomLog().info("UnGzipping stream (" + gZippedStream.length + " bytes)");
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(gZippedStream));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[32768];
        int readLength = -1;
        while ((readLength = gis.read(buffer)) != -1) {
            os.write(buffer, 0, readLength);
        }
        os.flush();
        os.close();
        byte[] unGzipped = os.toByteArray();
        EncryptionUtils.getCustomLog().info("UNGZIPPED");
        EncryptionUtils.getCustomLog().info("Original / unGzipped sizes (bytes): " + gZippedStream.length + " / " + unGzipped.length);
        return unGzipped;
    }

    public static byte[] unzipStreamAndGetEntry(byte[] zippedStream, String entryName) throws IOException {
        ZipEntry entry;
        assert (zippedStream != null) : "Zipped stream cannot be null";
        assert (entryName != null) : "Entry name cannot be null";
        EncryptionUtils.getCustomLog().info("Unzipping stream ({} bytes) to extract entry {}", (Object)zippedStream.length, (Object)entryName);
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zippedStream));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = null;
        int readLength = -1;
        while ((entry = zis.getNextEntry()) != null) {
            if (!entryName.equals(entry.getName())) continue;
            buffer = new byte[32768];
            EncryptionUtils.getCustomLog().info("Extracting: " + entry);
            while ((readLength = zis.read(buffer)) != -1) {
                os.write(buffer, 0, readLength);
            }
            break block0;
        }
        os.flush();
        os.close();
        if (buffer != null) {
            byte[] unzipped = os.toByteArray();
            EncryptionUtils.getCustomLog().info("Extracted entry {} from zipped stream", (Object)entryName);
            EncryptionUtils.getCustomLog().info("Unzipped content length is {} bytes", (Object)unzipped.length);
            return unzipped;
        }
        EncryptionUtils.getCustomLog().warn("Unable to find any entry named {} into provided zipped stream. Returning NULL", (Object)entryName);
        throw new FileNotFoundException("Unable to find any entry named " + entryName + " into provided zipped stream");
    }

    public static String[] listEntriesInZippedStream(byte[] zippedStream) throws Throwable {
        ZipEntry entry;
        EncryptionUtils.getCustomLog().info("Listing entries in zipped stream (" + zippedStream.length + " bytes)");
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zippedStream));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ArrayList<String> entries = new ArrayList<String>();
        while ((entry = zis.getNextEntry()) != null) {
            entries.add(entry.getName());
            EncryptionUtils.getCustomLog().info("Identified entry: " + entry);
        }
        os.flush();
        os.close();
        EncryptionUtils.getCustomLog().info("Unzipped file contains {} entries. Listing follows...", (Object)entries.size());
        int counter = 1;
        for (String e : entries) {
            EncryptionUtils.getCustomLog().info("Entry #{}: {}", (Object)counter++, (Object)e);
        }
        return entries.toArray(new String[entries.size()]);
    }

    private static String convertToHexString(byte[] toConvert) {
        assert (toConvert.length == 16) : "Result length (in bytes) should be 16 instead of " + toConvert.length;
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < toConvert.length) {
            result.append(Integer.toString((toConvert[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        assert (result.length() == 32) : "Converted result length should be 32 instead of " + result.length();
        return result.toString();
    }
}

