/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.singletons.lang;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import org.fao.vrmf.core.helpers.singletons.AbstractHelperSingleton;
import org.slf4j.Logger;

public final class ErrorManagementUtils
extends AbstractHelperSingleton {
    public static final String UNKNOWN_INVOKER = "<UNKNOWN INVOKER>";
    public static final String UNKNOWN_INVOKER_FULLY_QUALIFIED_CLASS = "<UNKNOWN INVOKER FULLY QUALIFIED CLASS>";
    public static final String UNKNOWN_INVOKER_CLASS = "<UNKNOWN INVOKER CLASS>";
    public static final String UNKNOWN_INVOKER_METHOD = "<UNKNOWN INVOKER METHOD>";
    public static final String UNKNOWN_INVOKER_CLASS_FILE = "<UNKNOWN INVOKER CLASS FILE>";
    public static final String UNKNOWN_INVOKER_LINE = "<UNKNOWN INVOKER LINE>";
    public static final int LINES_TO_SKIP_FOR_DIRECT_INVOKER = 2;
    public static final int LINES_TO_SKIP_FOR_PARENT_INVOKER = 3;

    private ErrorManagementUtils() {
    }

    private static Logger getCustomLog() {
        return AbstractHelperSingleton.getLogger(ErrorManagementUtils.class);
    }

    public static String appendCommonThrowableReportPart(String message, Throwable throwable) {
        String updatedMessage;
        if (throwable == null) {
            return message;
        }
        String realMessage = throwable.getCause() == null ? throwable.getMessage() : throwable.getCause().getMessage();
        String string = updatedMessage = realMessage == null ? "" : message;
        if (updatedMessage.length() > 0 && !updatedMessage.endsWith(" ")) {
            updatedMessage = String.valueOf(updatedMessage) + " ";
        }
        updatedMessage = String.valueOf(updatedMessage) + "[ Unexpected " + throwable.getClass().getName() + " caught. Reason: " + realMessage + " ]";
        return updatedMessage;
    }

    public static String serializeStackTrace(Throwable throwable) {
        assert (throwable != null) : "Throwable cannot be NULL";
        StringWriter ps = new StringWriter();
        PrintWriter pw = new PrintWriter(ps);
        throwable.printStackTrace(pw);
        return ps.toString();
    }

    public static String[] serializeAndSplitStackTrace(Throwable throwable) {
        String serialized = ErrorManagementUtils.serializeStackTrace(throwable);
        if (serialized != null) {
            return serialized.split("\\n");
        }
        return null;
    }

    public static String findDirectInvoker() {
        return ErrorManagementUtils.findInvoker(2);
    }

    public static String findParentInvoker() {
        return ErrorManagementUtils.findInvoker(3);
    }

    public static String findInvoker(String lineStopper) {
        assert (lineStopper != null) : "Line Stopper cannot be NULL";
        try {
            throw new RuntimeException("Lo and behold!");
        }
        catch (Throwable t) {
            BufferedReader br = null;
            try {
                String currentLine;
                String trace = ErrorManagementUtils.serializeStackTrace(t);
                br = new BufferedReader(new StringReader(trace));
                while ((currentLine = br.readLine()) != null && currentLine.indexOf(lineStopper) < 0) {
                }
                if (currentLine == null || currentLine.indexOf(lineStopper) < 0) {
                    return UNKNOWN_INVOKER;
                }
                String string = currentLine.substring(4);
                return string;
            }
            catch (Exception ee) {
                ErrorManagementUtils.getCustomLog().warn(ErrorManagementUtils.appendCommonThrowableReportPart("Unable to find invoker by reaching line stopper '" + lineStopper + "'", ee));
                return UNKNOWN_INVOKER;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception eee) {
                        ErrorManagementUtils.getCustomLog().error(ErrorManagementUtils.appendCommonThrowableReportPart("Unable to close buffered reader while attempting to find invoker", eee));
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String findInvoker(int linesToSkip) {
        assert (linesToSkip >= 0) : "Lines To Skip should be >= 0";
        try {
            throw new RuntimeException("Lo and behold!");
        }
        catch (Throwable t) {
            BufferedReader br = null;
            try {
                String trace = ErrorManagementUtils.serializeStackTrace(t);
                br = new BufferedReader(new StringReader(trace));
                String currentLine = br.readLine();
                int n = 0;
                while (true) {
                    block16: {
                        if (n <= linesToSkip && currentLine != null) break block16;
                    }
                    currentLine = br.readLine();
                    ++n;
                }
                String string = linesToSkip > 0 ? currentLine.substring(4) : currentLine;
                return string;
            }
            catch (Exception ee) {
                ErrorManagementUtils.getCustomLog().warn(ErrorManagementUtils.appendCommonThrowableReportPart("Unable to find invoker by skipping " + linesToSkip + " lines", ee));
                return UNKNOWN_INVOKER;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception eee) {
                        ErrorManagementUtils.getCustomLog().error(ErrorManagementUtils.appendCommonThrowableReportPart("Unable to close buffered reader while attempting to find invoker", eee));
                    }
                }
            }
        }
    }

    public static String getInvokerFullyQualifiedClass(String invocation) {
        try {
            StringTokenizer stk = new StringTokenizer(invocation, "()");
            String invokingMethod = stk.nextToken();
            return invokingMethod.substring(0, invokingMethod.lastIndexOf(46));
        }
        catch (Throwable t) {
            ErrorManagementUtils.getCustomLog().warn(ErrorManagementUtils.appendCommonThrowableReportPart("Unable to find invoker fully qualified class for invocation '" + invocation + "'", t));
            return UNKNOWN_INVOKER_FULLY_QUALIFIED_CLASS;
        }
    }

    public static String getInvokerClass(String invocation) {
        try {
            StringTokenizer stk = new StringTokenizer(invocation, "()");
            String invokingMethod = stk.nextToken();
            invokingMethod = invokingMethod.substring(0, invokingMethod.lastIndexOf(46));
            return invokingMethod.substring(invokingMethod.lastIndexOf(46) + 1);
        }
        catch (Throwable t) {
            ErrorManagementUtils.getCustomLog().warn(ErrorManagementUtils.appendCommonThrowableReportPart("Unable to retrieve invoker class from invocation '" + invocation + "'", t));
            return UNKNOWN_INVOKER_CLASS;
        }
    }

    public static String getInvokerMethod(String invocation) {
        try {
            StringTokenizer stk = new StringTokenizer(invocation, "()");
            String invokingMethod = stk.nextToken();
            return invokingMethod.substring(invokingMethod.lastIndexOf(46) + 1);
        }
        catch (Throwable t) {
            ErrorManagementUtils.getCustomLog().warn(ErrorManagementUtils.appendCommonThrowableReportPart("Unable to retrieve invoker method from invocation '" + invocation + "'", t));
            return UNKNOWN_INVOKER_METHOD;
        }
    }

    public static String getInvokerClassFile(String invocation) {
        try {
            StringTokenizer stk = new StringTokenizer(invocation, "()");
            stk.nextToken();
            String invokingLine = stk.nextToken();
            return invokingLine.substring(0, invokingLine.lastIndexOf(58));
        }
        catch (Throwable t) {
            ErrorManagementUtils.getCustomLog().warn(ErrorManagementUtils.appendCommonThrowableReportPart("Unable to retrieve invoker class file from invocation '" + invocation + "'", t));
            return UNKNOWN_INVOKER_CLASS_FILE;
        }
    }

    public static String getInvokerLine(String invocation) {
        try {
            StringTokenizer stk = new StringTokenizer(invocation, "()");
            stk.nextToken();
            String invokingLine = stk.nextToken();
            return invokingLine.substring(invokingLine.lastIndexOf(58) + 1);
        }
        catch (Throwable t) {
            ErrorManagementUtils.getCustomLog().warn(ErrorManagementUtils.appendCommonThrowableReportPart("Unable to retrieve invoker line from '" + invocation + "'", t));
            return UNKNOWN_INVOKER_LINE;
        }
    }

    public static void setDetailMessage(final Throwable toOverwrite, final String detailedMessage) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Field detailedMessageField = Throwable.class.getDeclaredField("detailMessage");
                    detailedMessageField.setAccessible(true);
                    detailedMessageField.set(toOverwrite, detailedMessage);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public static void setStackTrace(final Throwable toOverwrite, final StackTraceElement[] stackTrace) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Field detailedMessageField = Throwable.class.getDeclaredField("stackTrace");
                    detailedMessageField.setAccessible(true);
                    detailedMessageField.set(toOverwrite, stackTrace);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

