/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.singletons.lang.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.fao.vrmf.core.helpers.singletons.AbstractHelperSingleton;

public final class CollectionsUtils
extends AbstractHelperSingleton {
    private CollectionsUtils() {
    }

    public static String serializeCollection(Iterable<?> toSerialize) {
        StringBuffer serialized = new StringBuffer("{ ");
        if (toSerialize == null) {
            serialized.append("<NULL>");
        } else {
            for (Object current : toSerialize) {
                serialized.append("[ ");
                if (current != null) {
                    if (current.getClass().isArray()) {
                        serialized.append(CollectionsUtils.serializeArray((Object[])current));
                    } else if (Iterable.class.isAssignableFrom(current.getClass())) {
                        serialized.append(CollectionsUtils.serializeCollection((Iterable)current));
                    } else {
                        serialized.append(current.toString());
                    }
                } else {
                    serialized.append("<NULL>");
                }
                serialized.append(" ]");
                serialized.append(", ");
            }
            if (serialized.length() > 2) {
                serialized = new StringBuffer(serialized.subSequence(0, serialized.length() - 2));
            }
        }
        serialized.append(" }");
        return serialized.toString();
    }

    public static <C extends Comparable<? super C>> List<C> sortCollection(Collection<C> toSort) {
        if (toSort == null) {
            return null;
        }
        ArrayList<C> asList = new ArrayList<C>(toSort);
        Collections.sort(asList);
        return asList;
    }

    public static <C extends Comparable<? super C>> String serializeSortedCollection(Collection<C> toSort) {
        if (toSort == null) {
            return CollectionsUtils.serializeCollection(null);
        }
        ArrayList<C> asList = new ArrayList<C>(toSort);
        Collections.sort(asList);
        return CollectionsUtils.serializeCollection(asList);
    }

    public static <C extends Comparable<? super C>> C[] sortArray(C[] toSort) {
        if (toSort == null) {
            return null;
        }
        ArrayList<C> asList = new ArrayList<C>(Arrays.asList(toSort));
        Collections.sort(asList);
        return (Comparable[])asList.toArray(toSort);
    }

    public static <C extends Comparable<? super C>> String serializeSortedArray(C[] toSort) {
        if (toSort == null) {
            return CollectionsUtils.serializeArray(null);
        }
        ArrayList<C> asList = new ArrayList<C>(Arrays.asList(toSort));
        Collections.sort(asList);
        return CollectionsUtils.serializeArray(asList.toArray(toSort));
    }

    public static String serializeArray(Object[] toSerialize) {
        if (toSerialize == null) {
            return CollectionsUtils.serializeCollection(null);
        }
        return CollectionsUtils.serializeCollection(Arrays.asList(toSerialize));
    }

    public static String join(Object[] toJoin, String separator) {
        if (toJoin.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Object[] objectArray = toJoin;
        int n = toJoin.length;
        int n2 = 0;
        while (n2 < n) {
            Object current = objectArray[n2];
            result.append(current).append(separator);
            ++n2;
        }
        return result.substring(0, result.length() - separator.length());
    }

    public static String join(Collection<?> toJoin, String separator) {
        return CollectionsUtils.join(toJoin.toArray(new Object[toJoin.size()]), separator);
    }

    public static <ITEM> ITEM[] append(ITEM[] array, ITEM ... toAppend) {
        if (toAppend == null) {
            return array;
        }
        if (array == null) {
            return toAppend;
        }
        int initialLength = array.length;
        int addedLength = toAppend.length;
        array = Arrays.copyOf(array, initialLength + addedLength);
        ITEM[] ITEMArray = toAppend;
        int n = toAppend.length;
        int n2 = 0;
        while (n2 < n) {
            ITEM newItem = ITEMArray[n2];
            array[initialLength++] = newItem;
            ++n2;
        }
        return array;
    }

    public static <ITEM> ITEM[] append(ITEM initial, ITEM ... toAppend) {
        return CollectionsUtils.append(initial, toAppend);
    }

    public static <ITEM> ITEM[] prepend(ITEM[] array, ITEM ... toPrepend) {
        return CollectionsUtils.append(toPrepend, array);
    }

    public static <ITEM> ITEM[] prepend(ITEM initial, ITEM ... toPrepend) {
        return CollectionsUtils.append(toPrepend, new Object[]{initial});
    }

    public static <ITEM> ITEM[] behead(ITEM[] toSever, int headLength) {
        if (toSever == null) {
            return null;
        }
        if (headLength == 0) {
            return toSever;
        }
        return Arrays.copyOfRange(toSever, toSever.length <= headLength ? 0 : headLength, toSever.length <= headLength ? 0 : toSever.length);
    }

    public static <ITEM> ITEM[] behead(ITEM[] toSever) {
        return CollectionsUtils.behead(toSever, 1);
    }

    public static <ITEM> Collection<ITEM> behead(Collection<ITEM> toSever, int headLength) {
        if (toSever == null) {
            return null;
        }
        if (headLength > 0) {
            if (toSever.size() <= headLength) {
                toSever.clear();
            } else {
                int head = 0;
                Iterator<ITEM> iterator = toSever.iterator();
                while (iterator.hasNext()) {
                    if (head++ > headLength) break;
                    iterator.remove();
                }
            }
        }
        return toSever;
    }

    public static <ITEM> Collection<ITEM> behead(Collection<ITEM> toSever) {
        return CollectionsUtils.behead(toSever, 1);
    }
}

