/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.singletons.lang.objects;

import org.fao.vrmf.core.helpers.singletons.AbstractHelperSingleton;
import org.fao.vrmf.core.helpers.singletons.lang.ErrorManagementUtils;

public final class NumbersUtils
extends AbstractHelperSingleton {
    private NumbersUtils() {
    }

    public static <SOURCE_TYPE extends Number> SOURCE_TYPE trimPositiveNumber(SOURCE_TYPE toTrim) {
        if (toTrim == null || Double.isNaN(toTrim.doubleValue()) || Double.compare(toTrim.doubleValue(), 0.0) <= 0) {
            return null;
        }
        return toTrim;
    }

    public static <SOURCE_TYPE extends Number, TARGET_TYPE extends Number> TARGET_TYPE trimPositiveNumber(SOURCE_TYPE toTrim, Class<? extends TARGET_TYPE> targetType) throws NumberFormatException {
        if (toTrim == null || Double.compare(toTrim.doubleValue(), 0.0) <= 0) {
            return null;
        }
        try {
            return (TARGET_TYPE)((Number)targetType.getConstructor(String.class).newInstance(toTrim.toString()));
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            boolean isANumberFormatException = cause != null && cause instanceof NumberFormatException;
            throw new NumberFormatException(ErrorManagementUtils.appendCommonThrowableReportPart("Cannot trim " + toTrim + " to a positive value", isANumberFormatException ? cause : t));
        }
    }

    public static Integer roundTrimPositiveNumber(Float toTrim) {
        if (toTrim == null || Float.compare(toTrim.floatValue(), 0.0f) == 0 || Float.isNaN(toTrim.floatValue()) || Math.signum(toTrim.floatValue()) == -1.0f) {
            return null;
        }
        return Math.round(toTrim.floatValue());
    }

    public static Long roundTrimPositiveNumber(Double toTrim) {
        if (toTrim == null || Double.compare(toTrim, 0.0) == 0 || Double.isNaN(toTrim) || Math.signum(toTrim) == -1.0) {
            return null;
        }
        return Math.round(toTrim);
    }

    public static Long trimPositiveNumberToFloor(Double toTrim) {
        if (NumbersUtils.roundTrimPositiveNumber(toTrim) == null) {
            return null;
        }
        return Math.round(Math.floor(toTrim));
    }

    public static Long trimPositiveNumberToCeil(Double toTrim) {
        if (NumbersUtils.roundTrimPositiveNumber(toTrim) == null) {
            return null;
        }
        return Math.round(Math.ceil(toTrim));
    }

    public static Integer trimPositiveNumberToFloor(Float toTrim) {
        if (NumbersUtils.roundTrimPositiveNumber(toTrim) == null) {
            return null;
        }
        return Math.round((float)Math.floor(toTrim.floatValue()));
    }

    public static Integer trimPositiveNumberToCeil(Float toTrim) {
        if (NumbersUtils.roundTrimPositiveNumber(toTrim) == null) {
            return null;
        }
        return Math.round((float)Math.ceil(toTrim.floatValue()));
    }
}

