/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.singletons.text.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class JAXBUtils {
    public static boolean OMIT_XML_DECLARATION = true;
    public static boolean KEEP_XML_DECLARATION = !OMIT_XML_DECLARATION;

    public static <C extends Serializable> String toXML(C object) throws JAXBException, IOException {
        return JAXBUtils.toXML(object, KEEP_XML_DECLARATION);
    }

    public static <C extends Serializable> String toXML(Class<?>[] contextClasses, C object) throws JAXBException, IOException {
        return JAXBUtils.toXML(contextClasses, object, KEEP_XML_DECLARATION);
    }

    public static <C extends Serializable> String toXML(C object, boolean omitXMLDeclaration) throws JAXBException, IOException, UnsupportedEncodingException {
        return JAXBUtils.toXML(object, null, omitXMLDeclaration);
    }

    public static <C extends Serializable> String toXML(Class<?>[] contextClasses, C object, boolean omitXMLDeclaration) throws JAXBException, IOException, UnsupportedEncodingException {
        return JAXBUtils.toXML(contextClasses, object, null, omitXMLDeclaration);
    }

    public static <C extends Serializable> String toXML(C object, String rootName) throws JAXBException, IOException, UnsupportedEncodingException {
        return JAXBUtils.toXML(new Class[]{object.getClass()}, object, rootName, KEEP_XML_DECLARATION);
    }

    public static <C extends Serializable> String toXML(Class<?>[] contextClasses, C object, String rootName) throws JAXBException, IOException, UnsupportedEncodingException {
        return JAXBUtils.toXML(contextClasses, object, rootName, KEEP_XML_DECLARATION);
    }

    public static <C extends Serializable> String toXML(C object, String rootName, boolean omitXMLDeclaration) throws JAXBException, IOException, UnsupportedEncodingException {
        return JAXBUtils.toXML(new Class[]{object.getClass()}, object, rootName, omitXMLDeclaration);
    }

    public static <C extends Serializable> String toXML(Class<?>[] contextClasses, C object, String rootName, boolean omitXMLDeclaration) throws JAXBException, IOException, UnsupportedEncodingException {
        if (object == null) {
            return null;
        }
        Class[] allContextClasses = new Class[contextClasses == null ? 1 : contextClasses.length + 1];
        if (contextClasses != null) {
            System.arraycopy(contextClasses, 0, allContextClasses, 0, contextClasses.length);
        }
        allContextClasses[allContextClasses.length - 1] = object.getClass();
        return JAXBUtils.toXML(JAXBContext.newInstance((Class[])allContextClasses), object, rootName, omitXMLDeclaration);
    }

    public static <C extends Serializable> String toXML(JAXBContext context, C object) throws JAXBException, IOException {
        return JAXBUtils.toXML(context, object, KEEP_XML_DECLARATION);
    }

    public static <C extends Serializable> String toXML(JAXBContext context, C object, boolean omitXMLDeclaration) throws JAXBException, IOException, UnsupportedEncodingException {
        return JAXBUtils.toXML(context, object, null, omitXMLDeclaration);
    }

    public static <C extends Serializable> String toXML(JAXBContext context, C object, String rootName) throws JAXBException, IOException, UnsupportedEncodingException {
        return JAXBUtils.toXML(context, object, rootName, KEEP_XML_DECLARATION);
    }

    public static <C extends Serializable> String toXML(JAXBContext context, C object, String rootName, boolean omitXMLDeclaration) throws JAXBException, IOException, UnsupportedEncodingException {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        }
        JAXBElement root = new JAXBElement(new QName(rootName == null ? clazz.getSimpleName() : rootName), clazz, object);
        Marshaller marshaller = context.createMarshaller();
        if (omitXMLDeclaration == OMIT_XML_DECLARATION) {
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        }
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            marshaller.marshal((Object)root, (OutputStream)baos);
            baos.flush();
            String string = new String(baos.toByteArray(), "UTF-8").replaceAll("^\\n", "").replaceAll("\\n$", "");
            return string;
        }
        finally {
            try {
                baos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static <C extends Serializable> C fromXML(Class<C> clazz, String xml) throws JAXBException, UnsupportedEncodingException {
        return JAXBUtils.fromXML(clazz, null, xml, clazz.getSimpleName());
    }

    public static <C extends Serializable> C fromXML(Class<C> clazz, String xml, String rootName) throws JAXBException, UnsupportedEncodingException {
        return JAXBUtils.fromXML(clazz, null, xml, rootName);
    }

    public static <C extends Serializable> C fromXML(Class<C> clazz, Class<?>[] classes, String xml) throws JAXBException, UnsupportedEncodingException {
        if (xml == null || clazz == null) {
            return null;
        }
        return JAXBUtils.fromXML(clazz, classes, xml, clazz.getSimpleName());
    }

    public static <C extends Serializable> C fromXML(Class<C> clazz, Class<?>[] classes, String xml, String rootName) throws JAXBException, UnsupportedEncodingException {
        if (xml == null || clazz == null) {
            return null;
        }
        Class[] clazzes = new Class[1 + (classes == null ? 0 : classes.length)];
        clazzes[0] = clazz;
        if (classes != null && classes.length > 0) {
            System.arraycopy(classes, 0, clazzes, 1, classes.length);
        }
        JAXBContext ctx = JAXBContext.newInstance((Class[])clazzes);
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        return (C)((Serializable)ctx.createUnmarshaller().unmarshal((Source)new StreamSource(bais), clazz).getValue());
    }

    public static <C extends Serializable> void generateSchema(Class<?> ... classes) throws JAXBException, IOException {
        JAXBUtils.generateSchema(null, null, classes);
    }

    public static <C extends Serializable> void generateSchema(File dir, String xsdSchemaName, Class<?> ... classes) throws JAXBException, IOException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])classes);
        CustomSchemaOutputResolver sor = new CustomSchemaOutputResolver(dir, xsdSchemaName);
        jaxbContext.generateSchema((SchemaOutputResolver)sor);
    }

    public static class CustomSchemaOutputResolver
    extends SchemaOutputResolver {
        private final File _dir;
        private final String _xsdSchemaName;

        public CustomSchemaOutputResolver(File dir, String xsdSchemaName) {
            this._dir = dir;
            this._xsdSchemaName = xsdSchemaName;
        }

        public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
            File dir = this._dir == null ? new File("").getParentFile() : this._dir;
            File file = null;
            file = this._xsdSchemaName == null ? new File(dir, suggestedFileName) : new File(dir, this._xsdSchemaName);
            StreamResult result = new StreamResult(file);
            result.setSystemId(file.toURI().toURL().toString());
            return new StreamResult(file);
        }
    }
}

