/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.impl.design.patterns.cache;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.fao.vrmf.core.behaviours.design.patterns.cache.CacheBindingListener;
import org.fao.vrmf.core.behaviours.design.patterns.cache.CacheEntryUpdaterAction;
import org.fao.vrmf.core.behaviours.design.patterns.cache.CacheFacade;
import org.fao.vrmf.core.behaviours.design.patterns.cache.CacheInfo;
import org.fao.vrmf.core.behaviours.design.patterns.cache.CacheListener;
import org.fao.vrmf.core.behaviours.design.patterns.cache.exceptions.KeyAlreadyMappedException;
import org.fao.vrmf.core.behaviours.design.patterns.cache.exceptions.KeyIsNotMappedException;
import org.fao.vrmf.core.helpers.singletons.lang.classes.ClassUtils;
import org.fao.vrmf.core.impl.design.patterns.cache.CacheEntryInfo;
import org.fao.vrmf.core.impl.design.patterns.cache.SynchronizableCacheKey;
import org.fao.vrmf.core.impl.logging.ImmutableLoggingClient;

public abstract class AbstractCache<K, V>
extends ImmutableLoggingClient
implements CacheFacade<K, V> {
    protected Set<CacheListener<K, V>> _cacheListeners = Collections.synchronizedSet(new HashSet());
    protected boolean _areListenersEnabled;
    protected String _cacheID;

    public AbstractCache() {
        this._cacheID = ClassUtils.getThis(this);
    }

    public AbstractCache(String cacheID) {
        this._cacheID = cacheID;
    }

    @Override
    public final String getCacheID() {
        return this._cacheID;
    }

    @Override
    public final String getCacheUID() {
        String UID = String.valueOf(this._cacheID) + ":" + this.hashCode() + "@";
        try {
            UID = String.valueOf(UID) + InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable t) {
            this._log.error("Unable to fully build cache UID", t);
        }
        return UID;
    }

    @Override
    public final void addCacheListener(CacheListener<K, V> listener) {
        assert (listener != null) : "The Cache Listener to add cannot be NULL";
        this._cacheListeners.add(listener);
    }

    @Override
    public final void removeCacheListener(CacheListener<K, V> listener) {
        assert (listener != null) : "The Cache Listener to remove cannot be NULL";
        if (this._cacheListeners.contains(listener)) {
            this._cacheListeners.remove(listener);
        } else {
            this._log.warn(String.valueOf(ClassUtils.getThis(listener)) + " is not registered as a listener for " + ClassUtils.getThis(this));
        }
    }

    @Override
    public final void disableListeners() {
        this._areListenersEnabled = false;
    }

    @Override
    public final void enableListeners() {
        this._areListenersEnabled = true;
    }

    @Override
    public final boolean areListenersEnabled() {
        return this._areListenersEnabled;
    }

    @Override
    public final void clear() {
        this.doClear();
        if (this._areListenersEnabled) {
            this.notifyCacheCleared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V get(K key) {
        if (this.requiresExplicitKeySynchronization()) {
            SynchronizableCacheKey<K> synchronizableCacheKey = this.synchronizeKey(key);
            synchronized (synchronizableCacheKey) {
                return this.doGet(key);
            }
        }
        return this.doGet(key);
    }

    @Override
    public final V put(K key, V value) {
        return this.put(key, value, CacheFacade.CacheEntryValidity.ETERNAL.getValidity());
    }

    @Override
    public final V put(K key, V value, long validity) {
        assert (key != null) : "The Entry Key cannot be NULL";
        boolean overwritten = this.containsKey(key);
        V previousValue = this.doPut(key, value, validity);
        this.notifyUnbinding(key, previousValue);
        this.notifyBinding(key, value);
        if (this._areListenersEnabled) {
            if (overwritten) {
                this.notifyEntryEvent(EntryEvents.ENTRY_WAS_UPDATED, key, previousValue, value);
            }
            this.notifyEntryEvent(EntryEvents.ENTRY_WAS_ADDED, key, null, value);
        }
        return previousValue;
    }

    @Override
    public final V put(K key, V value, CacheFacade.CacheEntryValidity validity) {
        return this.put(key, value, validity.getValidity());
    }

    @Override
    public final V remove(K key) {
        assert (key != null) : "The Entry Key cannot be NULL";
        V removed = this.doRemove(key);
        this.notifyUnbinding(key, removed);
        if (this._areListenersEnabled) {
            this.notifyEntryEvent(EntryEvents.ENTRY_WAS_REMOVED, key, null, removed);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V safeGet(K key) throws KeyIsNotMappedException {
        if (this.requiresExplicitKeySynchronization()) {
            SynchronizableCacheKey<K> synchronizableCacheKey = this.synchronizeKey(key);
            synchronized (synchronizableCacheKey) {
                return this.unsynchronizedSafeGet(key);
            }
        }
        return this.unsynchronizedSafeGet(key);
    }

    private V unsynchronizedSafeGet(K key) throws KeyIsNotMappedException {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        throw new KeyIsNotMappedException(this, key);
    }

    @Override
    public final void safePut(K key, V value) throws KeyAlreadyMappedException {
        this.safePut(key, value, CacheFacade.CacheEntryValidity.ETERNAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void safePut(K key, V value, long validity) throws KeyAlreadyMappedException {
        K k = key;
        synchronized (k) {
            if (this.requiresExplicitKeySynchronization()) {
                SynchronizableCacheKey<K> synchronizableCacheKey = this.synchronizeKey(key);
                synchronized (synchronizableCacheKey) {
                    this.unsynchronizedSafePut(key, value, validity);
                }
            } else {
                this.unsynchronizedSafePut(key, value, validity);
            }
        }
    }

    private void unsynchronizedSafePut(K key, V value, long validity) throws KeyAlreadyMappedException {
        if (this.containsKey(key)) {
            throw new KeyAlreadyMappedException(this, key, this.get(key));
        }
        this.put(key, value, validity);
    }

    @Override
    public final void safePut(K key, V value, CacheFacade.CacheEntryValidity validity) throws KeyAlreadyMappedException {
        assert (validity != null) : "The Cache Entry Validity cannot be NULL";
        this.safePut(key, value, validity.getValidity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V safeRemove(K key) throws KeyIsNotMappedException {
        if (this.requiresExplicitKeySynchronization()) {
            SynchronizableCacheKey<K> synchronizableCacheKey = this.synchronizeKey(key);
            synchronized (synchronizableCacheKey) {
                return this.unsynchronizedSafeRemove(key);
            }
        }
        return this.unsynchronizedSafeRemove(key);
    }

    private V unsynchronizedSafeRemove(K key) throws KeyIsNotMappedException {
        if (this.containsKey(key)) {
            return this.remove(key);
        }
        throw new KeyIsNotMappedException(this, key);
    }

    protected abstract void doClear();

    protected abstract V doGet(K var1);

    protected abstract V doPut(K var1, V var2, long var3);

    protected abstract V doRemove(K var1);

    private void notifyBinding(K key, V value) {
        if (value != null && value instanceof CacheBindingListener) {
            try {
                ((CacheBindingListener)value).valueBound(this, key);
            }
            catch (Throwable t) {
                this._log.warn("Unable to notify 'valueBound' event for cache " + this, t);
            }
        }
    }

    private void notifyUnbinding(K key, V value) {
        if (value != null && value instanceof CacheBindingListener) {
            try {
                ((CacheBindingListener)value).valueUnbound(this, key);
            }
            catch (Throwable t) {
                this._log.warn("Unable to notify 'valueUnbound' event for cache " + this, t);
            }
        }
    }

    protected void notifyEntryEvent(EntryEvents entryEvent, K key, V oldValue, V value) {
        for (CacheListener<K, V> listener : this._cacheListeners) {
            if (listener == null) continue;
            try {
                switch (entryEvent) {
                    case ENTRY_WAS_REMOVED: {
                        listener.entryRemoved(this, key, value);
                        break;
                    }
                    case ENTRY_WAS_ADDED: {
                        listener.entryAdded(this, key, value);
                        break;
                    }
                    case ENTRY_WAS_UPDATED: {
                        listener.entryUpdated(this, key, oldValue, value);
                        break;
                    }
                    case ENTRY_WAS_EVICTED: {
                        listener.entryEvicted(this, key, value);
                        break;
                    }
                    case ENTRY_WAS_EXPIRED: {
                        listener.entryExpired(this, key, value);
                    }
                }
            }
            catch (Throwable t) {
                this._log.warn("Unable to notify event " + (Object)((Object)entryEvent) + " to listener " + listener, t);
            }
        }
    }

    protected void notifyCacheCleared() {
        for (CacheListener<K, V> listener : this._cacheListeners) {
            if (listener == null) continue;
            try {
                listener.cacheCleared(this);
            }
            catch (Throwable t) {
                this._log.warn("Unable to notify 'cache cleared' event to listener " + listener, t);
            }
        }
    }

    private SynchronizableCacheKey<K> synchronizeKey(K key) {
        assert (key != null) : "Key cannot be NULL";
        SynchronizableCacheKey<K> synchronizedKey = new SynchronizableCacheKey<K>(key);
        return synchronizedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void atomicUpdate(K key, V updater, CacheEntryUpdaterAction<V> updateAction) throws KeyIsNotMappedException {
        if (this.requiresExplicitKeySynchronization()) {
            SynchronizableCacheKey<K> synchronizableCacheKey = this.synchronizeKey(key);
            synchronized (synchronizableCacheKey) {
                this.put(key, updateAction.performUpdate(this.safeGet(key), updater));
            }
        } else {
            this.put(key, updateAction.performUpdate(this.safeGet(key), updater));
        }
    }

    @Override
    public CacheInfo<K, V> getCacheInfo() {
        CacheInfo info = new CacheInfo();
        info.setCacheID(this.getCacheID());
        info.setAreListenerEnabled(this.areListenersEnabled());
        info.setNumberOfListeners(this._cacheListeners == null ? 0 : this._cacheListeners.size());
        info.setNumberOfEntries(this.keySet() == null ? 0 : this.keySet().size());
        ArrayList entriesInfo = new ArrayList();
        if (this.keySet() != null) {
            for (Object k : this.keySet()) {
                entriesInfo.add(new CacheEntryInfo(k, this.get(k)));
            }
        }
        info.setCacheEntries(entriesInfo.toArray(new CacheEntryInfo[entriesInfo.size()]));
        return info;
    }

    protected static enum EntryEvents {
        ENTRY_WAS_REMOVED,
        ENTRY_WAS_ADDED,
        ENTRY_WAS_UPDATED,
        ENTRY_WAS_EVICTED,
        ENTRY_WAS_EXPIRED;


        public String toString() {
            switch (this) {
                case ENTRY_WAS_REMOVED: 
                case ENTRY_WAS_ADDED: 
                case ENTRY_WAS_UPDATED: 
                case ENTRY_WAS_EVICTED: 
                case ENTRY_WAS_EXPIRED: {
                    return this.name();
                }
            }
            return this.toString();
        }
    }
}

