/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.impl.design.patterns.cache.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.fao.vrmf.core.behaviours.design.patterns.factory.annotations.SingletonMarker;
import org.fao.vrmf.core.impl.design.patterns.cache.AbstractCache;

@SingletonMarker
public class SimpleCacheFacade<K, V>
extends AbstractCache<K, V> {
    private Map<K, V> _backingCache;

    public SimpleCacheFacade() {
        this(String.valueOf(SimpleCacheFacade.class.getSimpleName()) + "@" + System.currentTimeMillis());
    }

    public SimpleCacheFacade(String cacheID) {
        this(cacheID, 0);
    }

    public SimpleCacheFacade(String cacheID, Integer initialCapacity) {
        super(cacheID);
        this._backingCache = new HashMap(initialCapacity);
    }

    @Override
    public boolean providesPerEntryTimeout() {
        return false;
    }

    @Override
    public boolean providesGlobalTimeout() {
        return false;
    }

    @Override
    public boolean requiresExplicitKeySynchronization() {
        return true;
    }

    @Override
    public Object getBackingCache() {
        return this._backingCache;
    }

    @Override
    public int size() {
        return this._backingCache.size();
    }

    @Override
    public int exactSize() {
        return this.size();
    }

    @Override
    public Map<K, V> getAsMap() {
        return this._backingCache;
    }

    @Override
    public boolean containsKey(K key) {
        return this._backingCache.containsKey(key);
    }

    @Override
    public Collection<V> entries() {
        ArrayList<V> entries = new ArrayList<V>();
        for (K key : this.keySet()) {
            entries.add(this._backingCache.get(key));
        }
        return entries;
    }

    @Override
    public Set<K> keySet() {
        return this._backingCache.keySet();
    }

    @Override
    protected void doClear() {
        this._backingCache.clear();
    }

    @Override
    protected V doGet(K key) {
        return this._backingCache.get(key);
    }

    @Override
    protected V doPut(K key, V value, long validity) {
        return this._backingCache.put(key, value);
    }

    @Override
    public V doRemove(K key) {
        return this._backingCache.remove(key);
    }
}

