/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.models.application;

import java.io.Serializable;
import java.util.Date;
import org.fao.vrmf.core.helpers.singletons.io.EncryptionUtils;
import org.fao.vrmf.core.helpers.singletons.text.date.DateFormatterUtils;
import org.fao.vrmf.core.models.data.GenericData;

public class UserSession<SESSION_DATA extends Serializable>
extends GenericData {
    private static final long serialVersionUID = -6827790338092195588L;
    private String _id;
    private String _userId;
    private String _clientHost;
    private String _clientApp;
    private Date _loggedAt;
    private Date _lastPing;
    private SESSION_DATA _data;
    private static String DATE_FORMAT_PATTERN = "yy-MM-dd hh:mm:ss";

    private String buildSessionID() {
        String id = String.valueOf(this._userId) + "@" + this._clientApp + "@" + this._clientHost;
        try {
            id = EncryptionUtils.getMD5Sum(id).toUpperCase();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return id;
    }

    public String getId() {
        if (this._id == null) {
            this._id = this.buildSessionID();
        }
        return this._id;
    }

    public String getUserId() {
        return this._userId;
    }

    public void setUserId(String userId) {
        this._userId = userId;
    }

    public String getClientHost() {
        return this._clientHost;
    }

    public void setClientHost(String clientHost) {
        this._clientHost = clientHost;
    }

    public String getClientApp() {
        return this._clientApp;
    }

    public void setClientApp(String clientApp) {
        this._clientApp = clientApp;
    }

    public Date getLoggedAt() {
        return this._loggedAt;
    }

    public void setLoggedAt(Date loggedAt) {
        this._loggedAt = loggedAt;
    }

    public Date getLastPing() {
        return this._lastPing;
    }

    public void setLastPing(Date lastPing) {
        this._lastPing = lastPing;
    }

    public SESSION_DATA getData() {
        return this._data;
    }

    public void setData(SESSION_DATA data) {
        this._data = data;
    }

    public Object[] asRow() {
        return new Object[]{this._id, this._userId, this._clientApp.replaceAll("@.*", ""), this._clientHost, DateFormatterUtils.formatDateWithPattern(this._loggedAt, DATE_FORMAT_PATTERN), DateFormatterUtils.formatDateWithPattern(this._lastPing, DATE_FORMAT_PATTERN), this._data == null ? "<NO DATA>" : this._data.toString()};
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._clientApp == null ? 0 : this._clientApp.hashCode());
        result = 31 * result + (this._clientHost == null ? 0 : this._clientHost.hashCode());
        result = 31 * result + (this._data == null ? 0 : this._data.hashCode());
        result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
        result = 31 * result + (this._lastPing == null ? 0 : this._lastPing.hashCode());
        result = 31 * result + (this._loggedAt == null ? 0 : this._loggedAt.hashCode());
        result = 31 * result + (this._userId == null ? 0 : this._userId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof UserSession)) {
            return false;
        }
        UserSession other = (UserSession)obj;
        if (this._clientApp == null ? other._clientApp != null : !this._clientApp.equals(other._clientApp)) {
            return false;
        }
        if (this._clientHost == null ? other._clientHost != null : !this._clientHost.equals(other._clientHost)) {
            return false;
        }
        if (this._data == null ? other._data != null : !this._data.equals(other._data)) {
            return false;
        }
        if (this._id == null ? other._id != null : !this._id.equals(other._id)) {
            return false;
        }
        if (this._lastPing == null ? other._lastPing != null : !this._lastPing.equals(other._lastPing)) {
            return false;
        }
        if (this._loggedAt == null ? other._loggedAt != null : !this._loggedAt.equals(other._loggedAt)) {
            return false;
        }
        return !(this._userId == null ? other._userId != null : !this._userId.equals(other._userId));
    }
}

