/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.models.data;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.fao.vrmf.core.behaviours.data.Exportable;
import org.fao.vrmf.core.helpers.singletons.lang.classes.ClassUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;
import org.fao.vrmf.core.models.data.annotations.DoNotSerialize;
import org.fao.vrmf.core.models.data.annotations.NonSerializedFields;
import org.fao.vrmf.core.models.data.annotations.Skip;
import org.fao.vrmf.core.models.data.support.FieldDelta;

@XmlType(name="GenericData")
@XmlAccessorType(value=XmlAccessType.FIELD)
@NonSerializedFields(fieldNames={"batchId", "checksum", "updateDate", "comment"})
public class GenericData
implements Cloneable,
Exportable {
    private static final long serialVersionUID = -1033873379858985602L;

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        return ObjectsUtils.rawClone(this);
    }

    public String toString() {
        return ObjectsUtils.toString(1, this);
    }

    public final Collection<FieldDelta> diff(GenericData anotherData) throws Throwable {
        return AccessController.doPrivileged(new DiffPrivilegedAction(this, anotherData));
    }

    public String toSerializedForm() {
        return this.toString();
    }

    static class DiffPrivilegedAction
    implements PrivilegedExceptionAction<Collection<FieldDelta>> {
        private GenericData _source;
        private GenericData _target;

        public DiffPrivilegedAction(GenericData source, GenericData target) {
            this._source = source;
            this._target = target;
        }

        @Override
        public Collection<FieldDelta> run() throws Exception {
            HashSet<String> excludedFieldNames = new HashSet<String>();
            if (ClassUtils.isAnnotationPresent(this._target.getClass(), NonSerializedFields.class)) {
                excludedFieldNames.addAll(Arrays.asList(ClassUtils.getFirstAnnotationOfType(this._target.getClass(), NonSerializedFields.class).fieldNames()));
            }
            ArrayList<FieldDelta> result = new ArrayList<FieldDelta>();
            Collection<Field> fields = ObjectsUtils.listAllFields(this._source);
            FieldDelta current = null;
            for (Field field : fields) {
                if (field.isAnnotationPresent(DoNotSerialize.class) || field.isAnnotationPresent(Skip.class) && this.shouldSkip(field.getAnnotation(Skip.class), this._source) || excludedFieldNames.contains(field.getName())) continue;
                field.setAccessible(true);
                if (field.getName().indexOf("$") >= 0) continue;
                current = new FieldDelta();
                current.setField(field.getName());
                if (field.get(this._source) == null && field.get(this._target) == null) continue;
                if (field.get(this._source) == null && field.get(this._target) != null) {
                    current.setNewValue(field.get(this._target));
                    result.add(current);
                    continue;
                }
                if (field.get(this._source) == null) continue;
                if (field.get(this._target) == null) {
                    current.setOldValue(field.get(this._source));
                    current.setNewValue(null);
                    result.add(current);
                    continue;
                }
                if (field.get(this._source).equals(field.get(this._target))) continue;
                current.setOldValue(field.get(this._source));
                current.setNewValue(field.get(this._target));
                result.add(current);
            }
            return result;
        }

        private boolean shouldSkip(Skip discriminator, GenericData target) {
            try {
                return discriminator.checker().newInstance().check(target);
            }
            catch (Throwable t) {
                return false;
            }
        }
    }
}

