/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.models.data.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.fao.vrmf.core.behaviours.data.composite.DateReferencedUpdatable;
import org.fao.vrmf.core.behaviours.design.patterns.predicate.Action;
import org.fao.vrmf.core.extensions.collections.nu.impl.NuArrayList;
import org.fao.vrmf.core.impl.design.patterns.predicate.BasicPredicate;
import org.fao.vrmf.core.models.data.support.comparators.DateReferencedUpdatableDescendingComparator;

public final class DateReferencedUpdatableDataManager<DATA extends DateReferencedUpdatable>
implements Serializable {
    private static final long serialVersionUID = 1972850699990973096L;

    public DATA getCurrentData(List<DATA> data) {
        if (data == null || data.size() == 0) {
            return null;
        }
        if (data.size() == 1) {
            return (DATA)((DateReferencedUpdatable)data.get(0));
        }
        ArrayList<DATA> sorted = new ArrayList<DATA>(data);
        Collections.sort(sorted, new DateReferencedUpdatableDescendingComparator());
        return (DATA)((DateReferencedUpdatable)sorted.get(0));
    }

    public List<DATA> itemsBefore(List<DATA> data, final Date date) {
        assert (data != null) : "Data to scan cannot be NULL";
        assert (date != null) : "Date filter cannot be NULL";
        ArrayList result = new ArrayList();
        new NuArrayList<DATA>(data).forEachSelectedDo(new BasicPredicate<DATA>(){

            @Override
            public boolean is(DATA subject) {
                Date currentDate;
                Date date2 = currentDate = subject == null ? null : subject.getReferenceDate();
                return currentDate == null ? false : (currentDate.before(date) ? true : currentDate.equals(date));
            }
        }, new AddDataAction(result));
        return result;
    }

    public List<DATA> itemsAfter(List<DATA> data, final Date date) {
        assert (data != null) : "Data to scan cannot be NULL";
        assert (date != null) : "Date filter cannot be NULL";
        ArrayList result = new ArrayList();
        new NuArrayList<DATA>(data).forEachSelectedDo(new BasicPredicate<DATA>(){

            @Override
            public boolean is(DATA subject) {
                Date currentDate;
                Date date2 = currentDate = subject == null ? null : subject.getReferenceDate();
                return currentDate == null ? false : (currentDate.after(date) ? true : currentDate.equals(date));
            }
        }, new AddDataAction(result));
        return result;
    }

    public List<DATA> itemsBetween(List<DATA> data, final Date from, final Date to) {
        assert (data != null) : "Data to scan cannot be NULL";
        assert (from != null) : "Date 'from' filter cannot be NULL";
        assert (to != null) : "Date 'to' filter cannot be NULL";
        assert (to.after(from)) : "Date 'from' filter cannot follow date 'to' filter";
        ArrayList result = new ArrayList();
        new NuArrayList<DATA>(data).forEachSelectedDo(new BasicPredicate<DATA>(){

            @Override
            public boolean is(DATA subject) {
                Date currentDate;
                Date date = currentDate = subject == null ? null : subject.getReferenceDate();
                if (currentDate == null) {
                    return false;
                }
                return currentDate.after(from) || currentDate.equals(from) ? (currentDate.before(to) ? true : currentDate.equals(to)) : false;
            }
        }, new AddDataAction(result));
        return result;
    }

    private class AddDataAction
    implements Action<DATA> {
        private List<DATA> _target;

        public AddDataAction(List<DATA> target) {
            assert (target != null) : "Target cannot be NULL";
            this._target = target;
        }

        @Override
        public void perform(DATA subject) {
            assert (subject != null) : "Data to add cannot be NULL";
            this._target.add(subject);
        }
    }
}

