/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.tools.lexical.helpers;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class RomanNumbersConverter
extends NumberFormat {
    private static final long serialVersionUID = -5830053632997365135L;
    public static SymTab[] syms = new SymTab[]{new SymTab('M', 1000L), new SymTab('D', 500L), new SymTab('C', 100L), new SymTab('L', 50L), new SymTab('X', 10L), new SymTab('V', 5L), new SymTab('I', 1L)};

    @Override
    public StringBuffer format(double n, StringBuffer a, FieldPosition p) {
        return null;
    }

    @Override
    public Number parse(String text, ParsePosition parsePosition) {
        String s = text.substring(parsePosition.getIndex());
        long tot = 0L;
        long max = 0L;
        char[] ch = s.toUpperCase().toCharArray();
        int p = ch.length - 1;
        while (p >= 0) {
            int i = 0;
            while (i < syms.length) {
                if (RomanNumbersConverter.syms[i].symbol == ch[p]) {
                    if (RomanNumbersConverter.syms[i].value >= max) {
                        max = RomanNumbersConverter.syms[i].value;
                        tot += max;
                    } else {
                        tot -= RomanNumbersConverter.syms[i].value;
                    }
                }
                ++i;
            }
            --p;
        }
        parsePosition.setIndex(s.length());
        return new Long(tot);
    }

    public static long toLong(String s) {
        long tot = 0L;
        long max = 0L;
        char[] ch = s.toUpperCase().toCharArray();
        int p = ch.length - 1;
        while (p >= 0) {
            int i = 0;
            while (i < syms.length) {
                if (RomanNumbersConverter.syms[i].symbol == ch[p]) {
                    if (RomanNumbersConverter.syms[i].value >= max) {
                        max = RomanNumbersConverter.syms[i].value;
                        tot += max;
                    } else {
                        tot -= RomanNumbersConverter.syms[i].value;
                    }
                }
                ++i;
            }
            --p;
        }
        return tot;
    }

    @Override
    public StringBuffer format(long n, StringBuffer s, FieldPosition p) {
        while (n > 0L) {
            int i = 0;
            while (i < syms.length) {
                if (RomanNumbersConverter.syms[i].value <= n) {
                    int shift = i + i % 2;
                    if (i > 0 && shift < syms.length && RomanNumbersConverter.syms[i - 1].value - RomanNumbersConverter.syms[shift].value <= n) {
                        s.append(RomanNumbersConverter.syms[shift].symbol);
                        s.append(RomanNumbersConverter.syms[i - 1].symbol);
                        n = n - RomanNumbersConverter.syms[i - 1].value + RomanNumbersConverter.syms[shift].value;
                        i = -1;
                    } else {
                        s.append(RomanNumbersConverter.syms[i].symbol);
                        n -= RomanNumbersConverter.syms[i].value;
                        i = -1;
                    }
                }
                ++i;
            }
        }
        return s;
    }

    public static String toRoman(long n) {
        String s = "";
        while (n > 0L) {
            int i = 0;
            while (i < syms.length) {
                if (RomanNumbersConverter.syms[i].value <= n) {
                    int shift = i + i % 2;
                    if (i > 0 && shift < syms.length && RomanNumbersConverter.syms[i - 1].value - RomanNumbersConverter.syms[shift].value <= n) {
                        s = String.valueOf(s) + RomanNumbersConverter.syms[shift].symbol + RomanNumbersConverter.syms[i - 1].symbol;
                        n = n - RomanNumbersConverter.syms[i - 1].value + RomanNumbersConverter.syms[shift].value;
                        i = -1;
                    } else {
                        s = String.valueOf(s) + RomanNumbersConverter.syms[i].symbol;
                        n -= RomanNumbersConverter.syms[i].value;
                        i = -1;
                    }
                }
                ++i;
            }
        }
        return s;
    }

    public static class SymTab {
        char symbol;
        long value;

        public SymTab(char s, long v) {
            this.symbol = s;
            this.value = v;
        }
    }
}

