/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.tools.lexical.processors.impl;

import java.util.HashMap;
import java.util.Map;
import org.fao.vrmf.core.tools.lexical.processors.AbstractLexicalProcessor;

public final class ArabicProcessor
extends AbstractLexicalProcessor {
    private static final String ARABIC_LATIN_LETTERS = "a|a|a|e|b|t|th|j|h|kh|d|d|r|z|s|sh|s|d|t|z|'e|gh|f|q|k|l|m|n|h|w|y|a|'e|'|'e|la|h|?|!| |,|a|u|e|un|an|en| ".toUpperCase();
    private static final String ARABIC_LETTERS = "\u0627|\u0623|\u0622|\u0625|\u0628|\u062a|\u062b|\u062c|\u062d|\u062e|\u062f|\u0630|\u0631|\u0632|\u0633|\u0634|\u0635|\u0636|\u0637|\u0638|\u0639|\u063a|\u0641|\u0642|\u0643|\u0644|\u0645|\u0646|\u0647|\u0648|\u064a|\u0649|\u0626|\u0621|\u0624|\u0644\u0627|\u0629|\u061f|!|\u0640|\u060c|\u064e|\u064f|\u0650|\u064c|\u064b|\u064d|\u0651".toUpperCase();
    private static final String[] ARABIC_LATIN_LETTERS_ARRAY = ARABIC_LATIN_LETTERS.split("\\|");
    private static final String[] ARABIC_LETTERS_ARRAY = ARABIC_LETTERS.split("\\|");
    private static final Map<String, String> ARABIC_TO_LATIN_LETTERS_MAP = new HashMap<String, String>();
    private static final String CLEANUP_FIRST_PATTERN = "E(AE|\\s)";
    private static final String CLEANUP_SECOND_PATTERN = "([B-DF-HJ-NP-TV-Z])([B-DF-GJ-NP-TV-Z])";
    private boolean _cleanup = true;

    static {
        int l = 0;
        while (l < ARABIC_LETTERS_ARRAY.length) {
            ARABIC_TO_LATIN_LETTERS_MAP.put(ARABIC_LETTERS_ARRAY[l], ARABIC_LATIN_LETTERS_ARRAY[l] == " " ? "" : ARABIC_LATIN_LETTERS_ARRAY[l]);
            ++l;
        }
    }

    public ArabicProcessor() {
    }

    public ArabicProcessor(boolean cleanup) {
        this._cleanup = cleanup;
    }

    @Override
    public boolean mustProcess(String toProcess) {
        if (!super.mustProcess(toProcess)) {
            return false;
        }
        String uppercase = toProcess.toUpperCase();
        String[] stringArray = ARABIC_LETTERS_ARRAY;
        int n = ARABIC_LETTERS_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            String letter = stringArray[n2];
            if (uppercase.contains(letter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected String doProcess(String toProcess) {
        String processed = toProcess;
        for (String arabicLetter : ARABIC_TO_LATIN_LETTERS_MAP.keySet()) {
            processed = processed.replaceAll(arabicLetter, ARABIC_TO_LATIN_LETTERS_MAP.get(arabicLetter));
        }
        if (this._cleanup) {
            processed = processed.replaceAll(CLEANUP_FIRST_PATTERN, "$1");
            processed = processed.replaceAll(CLEANUP_SECOND_PATTERN, "$1E$2");
        }
        return processed;
    }
}

