/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.tools.lexical.processors.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.fao.vrmf.core.tools.lexical.processors.AbstractLexicalProcessor;

public final class GreekProcessor
extends AbstractLexicalProcessor {
    private static final String GREEK_LATIN_LETTERS = "A|B|G|D|E|Z|I|TH|I|K|L|M|N|X|O|R|P|S|T|Y|PH|CH|PS|O";
    private static final String GREEK_CAPITAL_LETTERS = "\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a1|\u03a0|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9";
    private static final String[] GREEK_LATIN_LETTERS_ARRAY = "A|B|G|D|E|Z|I|TH|I|K|L|M|N|X|O|R|P|S|T|Y|PH|CH|PS|O".split("\\|");
    private static final String[] GREEK_CAPITAL_LETTERS_ARRAY = "\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a1|\u03a0|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9".split("\\|");
    private static final String ALL_GREEK_LETTERS = "\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a1|\u03a0|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9".toLowerCase();
    private static final String LATIN_TO_GREEK_SIMILAR_LETTERS = "A|B|E|Z|H|I|K|M|N|X|O|P|T|Y";
    private static final String GREEK_TO_LATIN_SIMILAR_LETTERS = "\u0391|\u0392|\u0395|\u0396|\u0397|\u0399|\u039a|\u039c|\u039d|\u03a7|\u039f|\u03a1|\u03a4|\u03a5";
    private static final String[] LATIN_TO_GREEK_SIMILAR_LETTERS_ARRAY = "A|B|E|Z|H|I|K|M|N|X|O|P|T|Y".split("\\|");
    private static final String[] GREEK_TO_LATIN_SIMILAR_LETTERS_ARRAY = "\u0391|\u0392|\u0395|\u0396|\u0397|\u0399|\u039a|\u039c|\u039d|\u03a7|\u039f|\u03a1|\u03a4|\u03a5".split("\\|");
    private static final Map<String, String> GREEK_TO_LATIN_LETTERS_MAP = new HashMap<String, String>();
    private static final Map<String, String> LATIN_TO_GREEK_SIMILAR_LETTERS_MAP = new HashMap<String, String>();
    private static final Map<String, String> GREEK_DYPTONGUES_MAP = new HashMap<String, String>();

    static {
        String[] greekToLatinLetters = GREEK_LATIN_LETTERS.split("\\|");
        String[] greekCapitalLetters = GREEK_CAPITAL_LETTERS.split("\\|");
        int g = 0;
        while (g < greekCapitalLetters.length) {
            GREEK_TO_LATIN_LETTERS_MAP.put(greekCapitalLetters[g], greekToLatinLetters[g]);
            GREEK_TO_LATIN_LETTERS_MAP.put(greekCapitalLetters[g].toLowerCase(), greekToLatinLetters[g].toLowerCase());
            ++g;
        }
        String[] similarLatinToGreekLetters = LATIN_TO_GREEK_SIMILAR_LETTERS.split("\\|");
        String[] similarGreekToLatinLetters = GREEK_TO_LATIN_SIMILAR_LETTERS.split("\\|");
        int g2 = 0;
        while (g2 < similarLatinToGreekLetters.length) {
            LATIN_TO_GREEK_SIMILAR_LETTERS_MAP.put(similarLatinToGreekLetters[g2], similarGreekToLatinLetters[g2]);
            LATIN_TO_GREEK_SIMILAR_LETTERS_MAP.put(similarLatinToGreekLetters[g2].toLowerCase(), similarGreekToLatinLetters[g2].toLowerCase());
            ++g2;
        }
        GREEK_DYPTONGUES_MAP.put("\u0391\u03a5\u03a1", "AVR");
        GREEK_DYPTONGUES_MAP.put("\u0391\u03a5\u0391", "AVA");
        GREEK_DYPTONGUES_MAP.put("\u0395\u03a5\u0391", "EVA");
        GREEK_DYPTONGUES_MAP.put("\u0395\u03a5E", "EVE");
        GREEK_DYPTONGUES_MAP.put("\u0395\u03a5\u0399", "EVI");
        GREEK_DYPTONGUES_MAP.put("\u0395\u03a5\u0397", "EVI");
        GREEK_DYPTONGUES_MAP.put("\u0391\u03a5", "AU");
        GREEK_DYPTONGUES_MAP.put("\u0395\u03a5", "EU");
        GREEK_DYPTONGUES_MAP.put("\u0399\u03a5", "IV");
        GREEK_DYPTONGUES_MAP.put("\u039f\u03a5", "OU");
        GREEK_DYPTONGUES_MAP.put("\u0393\u0393", "NG");
        GREEK_DYPTONGUES_MAP.put("\u0393\u039e", "NX");
        GREEK_DYPTONGUES_MAP.put("\u0393\u03a7", "NCH");
        ArrayList<String> dyptongues = new ArrayList<String>(GREEK_DYPTONGUES_MAP.keySet());
        for (String dyptongue : dyptongues) {
            GREEK_DYPTONGUES_MAP.put(dyptongue.toLowerCase(), GREEK_DYPTONGUES_MAP.get(dyptongue).toLowerCase());
            GREEK_DYPTONGUES_MAP.put(GreekProcessor.capitalizeFirstLetter(dyptongue), GreekProcessor.capitalizeFirstLetter(GREEK_DYPTONGUES_MAP.get(dyptongue)));
        }
    }

    @Override
    public boolean mustProcess(String toProcess) {
        if (!super.mustProcess(toProcess)) {
            return false;
        }
        String uppercase = toProcess.toUpperCase();
        String[] stringArray = GREEK_CAPITAL_LETTERS_ARRAY;
        int n = GREEK_CAPITAL_LETTERS_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            String letter = stringArray[n2];
            if (uppercase.contains(letter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected String doProcess(String toProcess) {
        String processed = toProcess;
        for (String letter : LATIN_TO_GREEK_SIMILAR_LETTERS_MAP.keySet()) {
            processed = processed.replaceAll(letter, LATIN_TO_GREEK_SIMILAR_LETTERS_MAP.get(letter));
        }
        for (String dyptongue : GREEK_DYPTONGUES_MAP.keySet()) {
            processed = processed.replaceAll(dyptongue, GREEK_DYPTONGUES_MAP.get(dyptongue));
        }
        for (String greekLetter : GREEK_TO_LATIN_LETTERS_MAP.keySet()) {
            processed = processed.replaceAll(greekLetter, GREEK_TO_LATIN_LETTERS_MAP.get(greekLetter));
        }
        return processed;
    }
}

