/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.tools.lexical.processors.impl;

import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.fao.vrmf.core.tools.lexical.processors.AbstractReplacementStrategyAwareLexicalProcessor;

public class MultipleSpacesReplacerProcessor
extends AbstractReplacementStrategyAwareLexicalProcessor {
    public static final int DEFAULT_MIN_NUMBER_OF_SPACES = 2;
    private int _minNumberOfSpaces;

    public MultipleSpacesReplacerProcessor() {
        this(true, 2);
    }

    public MultipleSpacesReplacerProcessor(int minNumberOfSpaces) {
        this(true, 2);
        AssertionUtils.$pos(minNumberOfSpaces, "The minimum number of spaces must be greater than zero (currently {})", minNumberOfSpaces);
        this._minNumberOfSpaces = minNumberOfSpaces;
    }

    public MultipleSpacesReplacerProcessor(boolean replacementStrategy, int minNumberOfSpaces) {
        super(replacementStrategy);
        AssertionUtils.$pos(minNumberOfSpaces, "The minimum number of spaces must be greater than zero (currently {})", minNumberOfSpaces);
        this._minNumberOfSpaces = minNumberOfSpaces;
    }

    @Override
    protected String doProcess(String toProcess) {
        return StringUtils.rawTrim(toProcess).replaceAll("\\s{" + this._minNumberOfSpaces + ",}", this.getReplacement());
    }
}

