/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.tools.topology;

import java.io.Serializable;
import org.fao.vrmf.core.tools.topology.GraphNode;
import org.fao.vrmf.core.tools.topology.behaviours.WeightValue;

public final class WeightedGraphLink<I extends Serializable>
implements Serializable,
Comparable<WeightedGraphLink<I>> {
    private static final long serialVersionUID = -1780770170493032269L;
    private final GraphNode<I> _source;
    private final GraphNode<I> _target;
    private final WeightValue _weight;

    public WeightedGraphLink(GraphNode<I> source, GraphNode<I> target, WeightValue weight) {
        this._source = source;
        this._target = target;
        this._weight = weight;
    }

    public GraphNode<I> getSource() {
        return this._source;
    }

    public GraphNode<I> getTarget() {
        return this._target;
    }

    public WeightValue getWeight() {
        return this._weight;
    }

    public void reset() {
        this._source.reset();
        this._target.reset();
    }

    @Override
    public int compareTo(WeightedGraphLink<I> o) {
        int result = o.getWeight().compareTo(this.getWeight());
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._source == null ? 0 : this._source.hashCode());
        result = 31 * result + (this._target == null ? 0 : this._target.hashCode());
        result = 31 * result + (this._weight == null ? 0 : this._weight.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeightedGraphLink)) {
            return false;
        }
        WeightedGraphLink other = (WeightedGraphLink)obj;
        if (this._source == null ? other._source != null : !this._source.equals(other._source)) {
            return false;
        }
        if (this._target == null ? other._target != null : !this._target.equals(other._target)) {
            return false;
        }
        return !(this._weight == null ? other._weight != null : !this._weight.equals(other._weight));
    }

    public String toString() {
        return this._source + " -> " + this._target + " [ " + this._weight + " ]";
    }
}

