/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.matchlets.extended;

import java.util.HashSet;
import org.fao.fi.comet.core.model.common.TypedComplexName;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.core.model.support.MatchingType;
import org.fao.fi.comet.core.uniform.matchlets.skeleton.UScalarMatchletSkeleton;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;

public class GSAyMatchlet
extends UScalarMatchletSkeleton<ReferenceSpeciesData, ReferenceSpeciesData> {
    private static final long serialVersionUID = 5534829313877324698L;
    public static final String NAME = "GSAyMatchlet";
    private static final int SWITCH_G = 2;
    private static final int SWITCH_S = 4;
    private static final int SWITCH_Sr = 8;
    private static final int SWITCH_A = 16;
    private static final int SWITCH_y = 32;
    private static final int SWITCH_Y = 64;
    private static final int SWITCH_GSAy = 54;
    private static final int SWITCH_GSAY = 86;
    private static final int SWITCH_GSrAy = 58;
    private static final int SWITCH_GSrAY = 90;
    private static final int SWITCH_GSA = 22;
    private static final int SWITCH_GSrA = 26;
    private static final int SWITCH_GSY = 70;
    private static final int SWITCH_GSrY = 74;
    private static final int SWITCH_GS = 6;
    private static final int SWITCH_GSr = 10;
    private static final int SWITCH_SAy = 52;
    private static final int SWITCH_SrAy = 56;
    private static final int SWITCH_SAY = 84;
    private static final int SWITCH_SrAY = 88;
    private static final int SWITCH_GAy = 50;
    private static final int SWITCH_GAY = 82;

    public GSAyMatchlet() {
        this._name = NAME;
    }

    @Override
    public MatchingScore computeScore(ReferenceSpeciesData source, DataIdentifier sourceIdentifier, ReferenceSpeciesData sourceData, ReferenceSpeciesData target, DataIdentifier targetIdentifier, ReferenceSpeciesData targetData) {
        MatchingScore result = new MatchingScore(0.0, MatchingType.NON_AUTHORITATIVE);
        int triggered = 0;
        triggered |= this.test_G(sourceData, targetData) ? 2 : 0;
        triggered |= this.test_S(sourceData, targetData) ? 4 : 0;
        triggered |= this.test_Sr(sourceData, targetData) ? 8 : 0;
        triggered |= this.test_A(sourceData, targetData) ? 16 : 0;
        triggered |= this.test_y(sourceData, targetData) ? 32 : 0;
        result.setValue((double)this.score(triggered |= this.test_Y(sourceData, targetData) ? 64 : 0) * 0.01);
        return result;
    }

    private int score(int triggered) {
        switch (triggered) {
            case 54: {
                return 100;
            }
            case 86: {
                return 97;
            }
            case 58: {
                return 94;
            }
            case 90: {
                return 91;
            }
            case 22: {
                return 88;
            }
            case 26: {
                return 85;
            }
            case 70: {
                return 82;
            }
            case 74: {
                return 79;
            }
            case 6: {
                return 76;
            }
            case 10: {
                return 73;
            }
            case 52: {
                return 70;
            }
            case 56: {
                return 67;
            }
            case 84: {
                return 64;
            }
            case 88: {
                return 61;
            }
            case 50: {
                return 35;
            }
            case 82: {
                return 32;
            }
        }
        return 0;
    }

    private boolean hasParenthesis(String what) {
        return what != null && what.matches("^\\(.+\\)$");
    }

    private boolean areEquals(Object source, Object target) {
        return source == null && target == null ? true : (source == null || target == null ? false : source.equals(target));
    }

    private boolean test_G(ReferenceSpeciesData sourceData, ReferenceSpeciesData targetData) {
        return this.areEquals(sourceData.getGenus(), targetData.getGenus());
    }

    private boolean test_S(ReferenceSpeciesData sourceData, ReferenceSpeciesData targetData) {
        return this.areEquals(sourceData.getSpecies(), targetData.getSpecies());
    }

    private boolean test_Sr(ReferenceSpeciesData sourceData, ReferenceSpeciesData targetData) {
        return this.areEquals(sourceData.getNormalizedSpeciesCName(), targetData.getNormalizedSpeciesCName());
    }

    private boolean test_A(ReferenceSpeciesData sourceData, ReferenceSpeciesData targetData) {
        TypedComplexName authority;
        int n;
        int n2;
        TypedComplexName[] typedComplexNameArray;
        HashSet<String> sourceAuthorities = new HashSet<String>();
        HashSet<String> targetAuthorities = new HashSet<String>();
        if (sourceData.getAuthoritiesCName() != null) {
            typedComplexNameArray = sourceData.getAuthoritiesCName();
            n2 = typedComplexNameArray.length;
            n = 0;
            while (n < n2) {
                authority = typedComplexNameArray[n];
                sourceAuthorities.add(authority.getSimplifiedName());
                ++n;
            }
        }
        if (targetData.getAuthoritiesCName() != null) {
            typedComplexNameArray = targetData.getAuthoritiesCName();
            n2 = typedComplexNameArray.length;
            n = 0;
            while (n < n2) {
                authority = typedComplexNameArray[n];
                targetAuthorities.add(authority.getSimplifiedName());
                ++n;
            }
        }
        return sourceAuthorities.equals(targetAuthorities);
    }

    private boolean test_y(ReferenceSpeciesData sourceData, ReferenceSpeciesData targetData) {
        return this.hasParenthesis(sourceData.getAuthor()) && this.hasParenthesis(targetData.getAuthor()) && this.areEquals(sourceData.getAuthorityYear(), targetData.getAuthorityYear());
    }

    private boolean test_Y(ReferenceSpeciesData sourceData, ReferenceSpeciesData targetData) {
        return !this.test_y(sourceData, targetData) || this.areEquals(sourceData.getAuthorityYear(), targetData.getAuthorityYear());
    }

    @Override
    public String getDescription() {
        return "Performs GSAy matching between two reference species data";
    }

    @Override
    protected ReferenceSpeciesData doExtractData(ReferenceSpeciesData entity, DataIdentifier entityIdentifier) {
        return entity;
    }
}

