/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.parsers.impl;

import java.util.ArrayList;
import javax.inject.Named;
import javax.inject.Singleton;
import org.fao.fi.comet.domain.species.ReferenceSpeciesFactory;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.tools.parsers.StructuredSpeciesNameParser;
import org.fao.vrmf.core.helpers.singletons.lang.objects.CollectionsUtils;
import org.fao.vrmf.core.impl.logging.ImmutableLoggingClient;

@Singleton
@Named(value="IdentitySpeciesNameParser")
public class IdentitySpeciesNameParser
extends ImmutableLoggingClient
implements StructuredSpeciesNameParser {
    @Override
    public String getId() {
        return "IDENTITY";
    }

    @Override
    public String getName() {
        return "No action";
    }

    @Override
    public ReferenceSpeciesData[] parse(String[] names) {
        ArrayList<ReferenceSpeciesData> parsed = new ArrayList<ReferenceSpeciesData>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            parsed.add(this.doParse(name));
            ++n2;
        }
        return parsed.toArray(new ReferenceSpeciesData[parsed.size()]);
    }

    protected ReferenceSpeciesData doParse(String name) {
        String[] parts = this.extract(name);
        if (parts == null) {
            return null;
        }
        return ReferenceSpeciesFactory.newInstance(parts[0], parts[1]);
    }

    @Override
    public String makeUnstructured(String name) {
        String[] parts = this.extract(name);
        if (parts == null || parts[0] == null && parts[1] == null) {
            return null;
        }
        return parts[0] == null ? parts[1] : (parts[1] == null ? parts[0] : String.valueOf(parts[0]) + " " + parts[1]);
    }

    private String[] extract(String name) {
        String author = null;
        if (name != null) {
            String[] parts = name.split("\\;");
            String sciName = parts[0];
            if (parts.length > 1) {
                author = CollectionsUtils.join(CollectionsUtils.behead(parts), ";");
            }
            return new String[]{sciName, author};
        }
        return null;
    }
}

