/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.parsers.test;

import java.util.ArrayList;
import java.util.Collection;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.tools.parsers.SpeciesNameParser;
import org.fao.fi.comet.domain.species.tools.preprocess.RulesetManager;
import org.fao.fi.comet.domain.species.tools.preprocess.pre.PreparsingRules;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class AbstractSpeciesNameParserTest {
    protected SpeciesNameParser _parser;
    protected Collection<PreparsingRules> _preRules = new ArrayList<PreparsingRules>();

    public AbstractSpeciesNameParserTest() throws Throwable {
        String[] rulesets;
        String[] stringArray = rulesets = new String[]{"otherPreparsingRules", "bionymPreparsingRules", "commonPreparsingRules"};
        int n = rulesets.length;
        int n2 = 0;
        while (n2 < n) {
            String ruleset = stringArray[n2];
            this._preRules.add(RulesetManager.readEmbeddedPreparsingRules(ruleset));
            ++n2;
        }
    }

    protected String asString(ReferenceSpeciesData[] data) {
        ReferenceSpeciesData species = data[0];
        return String.valueOf(species.getScientificName()) + (species.getAuthor() == null ? "" : " (" + species.getAuthor() + ")");
    }

    protected String[] preprocess(String toPreprocess) {
        for (PreparsingRules rules : this._preRules) {
            toPreprocess = rules.apply(toPreprocess);
        }
        return new String[]{toPreprocess};
    }

    @Test
    public void testSimple() {
        String toParse = "Abramis brama";
        Assert.assertEquals((Object)toParse, (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
    }

    @Test
    public void testAuthor() {
        String toParse = "Abramis brama Linneus, Banfi, 1831";
        Assert.assertEquals((Object)"Abramis brama (Linneus, Banfi, 1831)", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
    }

    @Test
    public void testSubspecie() {
        Assume.assumeTrue(("SIMPLE".equals(this._parser.getId()) || "GNI_LEGACY".equals(this._parser.getId()) ? 1 : 0) != 0);
        String toParse = "Abramis fimbriata brama Linneus, 1831";
        Assert.assertEquals((Object)"Abramis fimbriata (Linneus, 1831)", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
    }

    @Test
    public void testSingleWord() {
        String toParse = "Abramisbrama (Linneus, 1831)";
        Assert.assertEquals((Object)"Abramisbrama (Linneus, 1831)", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
    }

    @Test
    public void testBrackets() {
        Assume.assumeTrue((boolean)"SIMPLE".equals(this._parser.getId()));
        String toParse = "Pamdea conica [Quoy & Gaimard, 1827]";
        Assert.assertEquals((Object)"Pamdea conica (Quoy, Gaimard, 1827)", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
    }

    @Test
    public void testOpenBracket() {
        Assume.assumeTrue((boolean)"SIMPLE".equals(this._parser.getId()));
        String toParse = "Pamdea conica [Quoy & Gaimard, 1827";
        Assert.assertEquals((Object)"Pamdea conica (Quoy, Gaimard, 1827)", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
    }

    @Test
    public void testSingleQuotes() {
        String toParse = "Crenicichla wallacii 'steakhouse'";
        Assert.assertEquals((Object)"Crenicichla wallacii", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
    }

    @Test
    public void testDoubleQuotes() {
        Assume.assumeTrue(("SIMPLE".equals(this._parser.getId()) || "GNI_LEGACY".equals(this._parser.getId()) ? 1 : 0) != 0);
        String toParse = "Crenicichla wallacii \"steakhouse\"";
        Assert.assertEquals((Object)"Crenicichla wallacii", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
    }

    @Test
    public void testSPPRemoval() {
        Assume.assumeTrue((boolean)"SIMPLE".equals(this._parser.getId()));
        String toParse = "Callogobius spp";
        Assert.assertEquals((Object)"Callogobius", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
        toParse = "Callogobius sp.";
        Assert.assertEquals((Object)"Callogobius", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
        toParse = "Crenicichla  n sp 'o-wallacei'";
        Assert.assertEquals((Object)"Crenicichla", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
        toParse = "Crenicichla  sppaarsei spp. 'o-wallacei'";
        Assert.assertEquals((Object)"Crenicichla sppaarsei", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
        toParse = "Spaarsei Crenicichla sPp. 'o-wallacei'";
        Assert.assertEquals((Object)"Spaarsei Crenicichla", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
        toParse = "Moenkhausia aff browni";
        Assert.assertEquals((Object)"Moenkhausia browni", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
    }

    @Test
    public void testCFRemoval() {
        Assume.assumeTrue((boolean)"SIMPLE".equals(this._parser.getId()));
        String toParse = "Callogobius cf";
        Assert.assertEquals((Object)"Callogobius", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
        toParse = "Callogobius cf.";
        Assert.assertEquals((Object)"Callogobius", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
        toParse = "Crenicichla  n cf 'o-wallacei'";
        Assert.assertEquals((Object)"Crenicichla", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
        toParse = "Crenicichla  sppaarsei cf. 'o-wallacei'";
        Assert.assertEquals((Object)"Crenicichla sppaarsei", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
        toParse = "Cfaarsei Crenicichla cFf. 'o-wallacei'";
        Assert.assertEquals((Object)"Cfaarsei Crenicichla", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
    }

    @Test
    public void testCommonAdditionalCommentsRemoval() {
        Assume.assumeTrue((boolean)"SIMPLE".equals(this._parser.getId()));
        String toParse = "Lepidotrigla juv/unident";
        Assert.assertEquals((Object)"Lepidotrigla", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
        toParse = "Arnoglossus unident juv";
        Assert.assertEquals((Object)"Arnoglossus", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
        toParse = "Arnoglossus unidentificatus juv";
        Assert.assertEquals((Object)"Arnoglossus unidentificatus", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
        toParse = "Unidentified leptocephalus, leptocephalus holti non Schmidt, 1909, species 3";
        Assert.assertEquals((Object)"leptocephalus leptocephalus (Schmidt, 1909)", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
        toParse = "Geophagus sp juveniles";
        Assert.assertEquals((Object)"Geophagus", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
        toParse = "Arnoglossus unidentifiable (no lat line)";
        Assert.assertEquals((Object)"Arnoglossus", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
    }

    @Test
    public void testAcronymRemoval() {
        String toParse = "Chaetostoma MK sp 2";
        Assert.assertEquals((Object)"Chaetostoma", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
        toParse = "Callogobius DFH sp 7";
        Assert.assertEquals((Object)"Callogobius", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
    }

    @Test
    public void testMisc() {
        String toParse = "Parupeneus sp c cf. bensasi";
        Assert.assertEquals((Object)"Parupeneus bensasi", (Object)this.asString(this._parser.parse(this.preprocess(toParse))));
    }

    @Test
    public void testAuthority() {
        Assume.assumeTrue((boolean)"SIMPLE".equals(this._parser.getId()));
        String toTest = "Etmopterus sp. b [in last & stevens, 1994]";
        Assert.assertEquals((Object)"Etmopterus (last, stevens, 1994)", (Object)this.asString(this._parser.parse(new String[]{toTest})));
    }

    @Test
    public void testAuthority2() {
        Assume.assumeTrue((boolean)"SIMPLE".equals(this._parser.getId()));
        String toTest = "Dipturus sp. f [in last & stevens-gerrard, 1994, as raja sp. f]";
        Assert.assertEquals((Object)"Dipturus (last, stevens-gerrard, 1994)", (Object)this.asString(this._parser.parse(new String[]{toTest})));
    }

    @Test
    public void testAuthority3() {
        String toTest = "Raja (dipturus) sp. 2 [r.sp. a]";
        Assert.assertEquals((Object)"Raja", (Object)this.asString(this._parser.parse(new String[]{toTest})));
    }

    @Test
    public void testAuthority4() {
        String toTest = "Hoplostethus mediterraneus Foobazzi & Cuvier, 1829";
        Assert.assertEquals((Object)"Hoplostethus mediterraneus (Foobazzi, Cuvier, 1829)", (Object)this.asString(this._parser.parse(new String[]{toTest})));
    }

    @Test
    public void testAuthority5() {
        Assume.assumeTrue((boolean)"SIMPLE".equals(this._parser.getId()));
        String toTest = "Upeneus cf sp. 1 (sainsbury, 1999)";
        Assert.assertEquals((Object)"Upeneus (sainsbury, 1999)", (Object)this.asString(this._parser.parse(new String[]{toTest})));
    }

    @Test
    public void testAuthority5b() {
        Assume.assumeTrue((boolean)"SIMPLE".equals(this._parser.getId()));
        String toTest = "Upeneus cf sp. 1 (sainsbury et al., 1999)";
        Assert.assertEquals((Object)"Upeneus (sainsbury, 1999)", (Object)this.asString(this._parser.parse(new String[]{toTest})));
    }

    @Test
    public void testAuthority5c() {
        Assume.assumeTrue((boolean)"SIMPLE".equals(this._parser.getId()));
        String toTest = "Upeneus cf sp. 1 sainsbury, Barfoozzi 1999";
        Assert.assertEquals((Object)"Upeneus sainsbury (Barfoozzi, 1999)", (Object)this.asString(this._parser.parse(new String[]{toTest})));
    }

    @Test
    public void testAuthority6() {
        String toTest = "Solea senegalensis Kaup, 1862";
        Assert.assertEquals((Object)"Solea senegalensis (Kaup, 1862)", (Object)this.asString(this._parser.parse(new String[]{toTest})));
    }

    @Test
    public void testAuthority6b() {
        String toTest = "Solea senegalensis De Kaup, 1862";
        Assert.assertEquals((Object)"Solea senegalensis (De Kaup, 1862)", (Object)this.asString(this._parser.parse(new String[]{toTest})));
    }

    @Test
    public void testAuthority7() {
        String toTest = "Solea senegalensis (De Kaup, 1862)";
        Assert.assertEquals((Object)"Solea senegalensis (De Kaup, 1862)", (Object)this.asString(this._parser.parse(new String[]{toTest})));
    }
}

