/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.extras.matchlets.helpers;

import java.io.Serializable;
import org.fao.vrmf.core.behaviours.data.Valued;

public final class ValueDistanceHelper<DATA extends Valued<? extends Number>>
implements Serializable {
    private static final long serialVersionUID = -7425081492706257342L;

    public final Double getRelativeValueDistance(DATA firstData, DATA secondData) {
        double relativeDistance;
        if (firstData == null || firstData.getValue() == null || secondData == null || secondData.getValue() == null) {
            return null;
        }
        double firstValue = ((Number)firstData.getValue()).doubleValue();
        double secondValue = ((Number)secondData.getValue()).doubleValue();
        double maxValue = Math.max(Math.abs(firstValue), Math.abs(secondValue));
        double distance = Math.abs(firstValue - secondValue);
        double d = relativeDistance = maxValue == 0.0 ? 0.0 : distance / maxValue;
        assert (relativeDistance >= 0.0 && relativeDistance <= 1.0) : "Returned relative distance shall range between 0 and 1 included (was: " + relativeDistance + ")";
        return relativeDistance;
    }
}

