/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.tools.lexical.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.fao.vrmf.core.tools.lexical.processors.AbstractLexicalProcessorsQueue;
import org.fao.vrmf.core.tools.lexical.processors.LexicalProcessor;
import org.fao.vrmf.core.tools.lexical.processors.MultipartLexicalProcessorQueue;

public abstract class AbstractMultipartLexicalProcessorsQueue
extends AbstractLexicalProcessorsQueue
implements MultipartLexicalProcessorQueue {
    private Collection<LexicalProcessor> _partProcessors = this.doGetActualPartProcessors();
    private Collection<LexicalProcessor> _postProcessors = this.doGetActualPostProcessors();

    protected abstract Collection<LexicalProcessor> doGetActualPartProcessors();

    protected abstract Collection<LexicalProcessor> doGetActualPostProcessors();

    public AbstractMultipartLexicalProcessorsQueue() {
        if (this._partProcessors != null) {
            this._partProcessors = Collections.unmodifiableCollection(this._partProcessors);
        }
        if (this._postProcessors != null) {
            this._postProcessors = Collections.unmodifiableCollection(this._postProcessors);
        }
    }

    @Override
    public final Collection<LexicalProcessor> getPartProcessors() {
        return this._partProcessors;
    }

    @Override
    public final Collection<LexicalProcessor> getPostProcessors() {
        return this._postProcessors;
    }

    @Override
    protected String doProcess(String toProcess) {
        String processed = toProcess;
        if (this._processors != null) {
            for (LexicalProcessor processor : this._processors) {
                if (processor == null) continue;
                processed = processor.process(processed);
            }
        }
        String[] parts = processed == null ? null : this.extract(processed);
        ArrayList<String> processedParts = new ArrayList<String>();
        if (parts != null && parts.length > 0 && this._partProcessors != null) {
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                for (LexicalProcessor processor : this._partProcessors) {
                    if (processor == null) continue;
                    part = processor.process(part);
                }
                if (part != null) {
                    processedParts.add(part);
                }
                ++n2;
            }
        }
        if (processedParts.isEmpty()) {
            return null;
        }
        processed = this.join(processedParts.toArray(new String[processedParts.size()]));
        if (this._postProcessors != null) {
            for (LexicalProcessor processor : this._postProcessors) {
                if (processor == null) continue;
                processed = processor.process(processed);
            }
        }
        return processed;
    }
}

