/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.matchlets.extended;

import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletDefaultSerializationExclusionPolicy;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletIsCutoffByDefault;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletIsOptionalByDefault;
import org.fao.fi.comet.core.model.matchlets.support.MatchingSerializationExclusionPolicy;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.core.model.support.MatchingType;
import org.fao.fi.comet.core.uniform.matchlets.skeleton.UScalarMatchletSkeleton;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;

@MatchletIsOptionalByDefault
@MatchletIsCutoffByDefault
@MatchletDefaultSerializationExclusionPolicy(value={MatchingSerializationExclusionPolicy.NON_PERFORMED})
public class AuthorityYearMatchlet
extends UScalarMatchletSkeleton<ReferenceSpeciesData, Integer> {
    private static final long serialVersionUID = 2057284178844548705L;
    public static final String NAME = "AuthorityYearMatchlet";
    private int _maxDelta = 10;

    public AuthorityYearMatchlet() {
        this._name = NAME;
    }

    public AuthorityYearMatchlet(int maxDelta) {
        this();
        AssertionUtils.$true(maxDelta >= 0, "Max year delta should be greater than (or equal to) zero (currently: {})", maxDelta);
        this._maxDelta = maxDelta;
    }

    @Override
    public String getDescription() {
        return "Matches authority years as extracted from a pair of input / reference matched entities";
    }

    @Override
    protected Integer doExtractData(ReferenceSpeciesData entity, DataIdentifier dataIdentifier) {
        return entity.getAuthorityYear();
    }

    @Override
    public MatchingScore computeScore(ReferenceSpeciesData source, DataIdentifier sourceIdentifier, Integer sourceData, ReferenceSpeciesData target, DataIdentifier targetIdentifier, Integer targetData) {
        int delta = Math.abs(sourceData - targetData);
        MatchingScore result = new MatchingScore(0.0, MatchingType.NON_AUTHORITATIVE);
        double scoreAsNumber = 0.0;
        double scoreAsString = 0.0;
        if (this._maxDelta == 0) {
            if (delta == 0) {
                scoreAsNumber = 1.0;
            }
        } else if (delta <= this._maxDelta) {
            scoreAsNumber = 1.0 - (double)delta * 1.0 / (double)this._maxDelta;
        }
        scoreAsString = StringUtils.computeRelativeSimilarity(String.valueOf(sourceData), String.valueOf(targetData));
        result.setValue(Math.max(scoreAsNumber, scoreAsString));
        return result;
    }
}

