/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.process;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

public class DLTest {
    private static final String[][] TAFs = new String[][]{{"ASFIS", "http://goo.gl/XHXA7Z"}, {"COL_CHORDATA", "http://goo.gl/ELatxE"}, {"COL_MAMMALIA", "http://goo.gl/KgGcBV"}, {"FISHBASE", "http://goo.gl/NV127D"}, {"IRMNG_ACTINOPTERYGII", "http://goo.gl/XXkTq6"}, {"OBIS", "http://goo.gl/ueLliA"}, {"OBIS_PLATYHELMINTHES", "http://goo.gl/5amAbt"}, {"OBIS_ANIMALIA", "http://goo.gl/eNtNpI"}, {"OBIS_CNIDARIA", "http://goo.gl/FJ5jHE"}, {"OBIS_ECHINODERMATA", "http://goo.gl/1fONj9"}, {"WORMS_ANIMALIA", "http://goo.gl/1e7VXX"}, {"WORMS_ANIMALIA_FULL", "http://goo.gl/vmrkDJ"}, {"WORMS_PISCES", "http://goo.gl/jFqskM"}};

    private static final long[] fetch(String label, String URL2) throws IOException {
        long start = System.currentTimeMillis();
        URL url = new URL(URL2);
        URLConnection urlConnection = url.openConnection();
        urlConnection.setReadTimeout(60000);
        byte[] buffer = new byte[16384];
        int len = -1;
        int totalLen = 0;
        while ((len = urlConnection.getInputStream().read(buffer)) != -1) {
            totalLen += len;
        }
        long end = System.currentTimeMillis();
        return new long[]{end - start, totalLen};
    }

    public static final void main(String[] args) throws Throwable {
        StringBuilder csv = new StringBuilder();
        csv.append("TAF;");
        csv.append("URL;");
        csv.append("size;");
        csv.append("time;");
        csv.append("throughput\n");
        String[][] stringArray = TAFs;
        int n = TAFs.length;
        int n2 = 0;
        while (n2 < n) {
            String[] in = stringArray[n2];
            System.out.print("Fetching " + in[0] + " from " + in[1] + ": ");
            long[] results = DLTest.fetch(in[0], in[1]);
            long time = results[0];
            long size = results[1];
            double throughput = (double)size * 1.0 / 1024.0 / 1024.0 * 1000.0 / ((double)time * 1.0);
            System.out.println(String.valueOf(size) + " bytes fetched in " + time + " mSec. with a throughput of " + throughput + " MB/s");
            csv.append(in[0]).append(";");
            csv.append(in[1]).append(";");
            csv.append(size).append(";");
            csv.append(time).append(";");
            csv.append(throughput).append("\n");
            ++n2;
        }
        System.out.println(csv);
    }
}

