/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PortalUtil;
import gr.cite.bluebridge.endpoint.EndpointManager;
import gr.cite.bluebridge.endpoint.ServiceProfile;
import gr.cite.bluebridge.endpoint.exceptions.ServiceDiscoveryException;
import gr.cite.regional.data.collection.portlet.web.HttpUtils;
import gr.cite.regional.data.collection.portlet.web.SingletonHttpClient;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ProcessingException;
import org.gcube.common.portal.PortalContext;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class BaseController {
    private static Log _log = LogFactoryUtil.getLog(BaseController.class);
    private EndpointManager endpointManager;
    @Autowired
    public SingletonHttpClient singletonHttpClient;
    public String host;
    public String token;
    protected static String scope;
    protected static String username;

    @RenderMapping
    public String renderHome(Model model, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        _log.debug((Object)"Rendering view");
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        model.addAttribute("userLocale", (Object)PortalUtil.getHttpServletRequest((PortletRequest)renderRequest).getLocale().toString());
        model.addAttribute("username", (Object)PortalUtil.getUser((PortletRequest)renderRequest).getScreenName());
        return "home";
    }

    @ResourceMapping(value="locale")
    public void getLocale(ResourceRequest request, ResourceResponse response) {
    }

    @ExceptionHandler(value={ConnectException.class, ProcessingException.class, PortletException.class})
    public void handleException(Exception ex, ResourceRequest request, ResourceResponse response) {
        request.setAttribute("exception", (Object)ex);
        _log.error((Object)"Could not connect to server");
        String result = "Failed to contact server. Maybe server is offline";
        HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
    }

    public ServiceProfile getRdbServiceProfile() {
        ServiceProfile rdbServiceProfile = new ServiceProfile();
        rdbServiceProfile.setServiceClass("RegionalDataCollection");
        rdbServiceProfile.setServiceName("regional-data-collection-main-service");
        rdbServiceProfile.setPathEndsWith("/");
        return rdbServiceProfile;
    }

    public List<String> discoverService(String scope, ServiceProfile serviceProfile) {
        this.endpointManager = new EndpointManager();
        ArrayList<String> endpoints = new ArrayList();
        try {
            endpoints = this.endpointManager.getServiceEndpoints(scope, serviceProfile);
        }
        catch (ServiceDiscoveryException e) {
            _log.error((Object)e.getMessage());
        }
        return endpoints;
    }

    public String discoverService(ResourceRequest request) {
        PortalContext pContext = PortalContext.getConfiguration();
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)request);
        scope = pContext.getCurrentScope(httpServletRequest);
        GCubeUser user = pContext.getCurrentUser(httpServletRequest);
        String username = user.getUsername();
        String discoveredHost = (String)this.discoverService(scope, this.getRdbServiceProfile()).get(0);
        return discoveredHost;
    }
}

