/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.portlet;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import gr.cite.regional.data.collection.portlet.BaseController;
import gr.cite.regional.data.collection.portlet.models.DataCollection;
import gr.cite.regional.data.collection.portlet.models.DataModel;
import gr.cite.regional.data.collection.portlet.models.Domain;
import gr.cite.regional.data.collection.portlet.models.UserReference;
import gr.cite.regional.data.collection.portlet.web.HttpUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Date;
import java.util.HashMap;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.ws.rs.core.Response;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
public class DataCollectionController
extends BaseController {
    private static Log _log = LogFactoryUtil.getLog(DataCollectionController.class);

    @ResourceMapping(value="getAllDataCollections")
    public void getAllDataCollections(ResourceRequest request, ResourceResponse response) throws ConnectException {
        _log.debug((Object)"Getting all data collections");
        String serviceUrl = "dataCollections";
        HashMap headers = new HashMap();
        Response clientResponse = this.singletonHttpClient.doGet(serviceUrl, headers);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        String result = (String)clientResponse.readEntity(String.class);
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        } else {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)result);
        }
    }

    @ResourceMapping(value="addDataCollection")
    public void addDataCollection(ResourceRequest request, ResourceResponse response) throws IOException {
        _log.debug((Object)"Adding data collection");
        String label = ParamUtil.getString((PortletRequest)request, (String)"label");
        long openFrom = ParamUtil.getLong((PortletRequest)request, (String)"openFrom");
        long openTo = ParamUtil.getLong((PortletRequest)request, (String)"openTo");
        int dataModelId = ParamUtil.getInteger((PortletRequest)request, (String)"dataModelId");
        String serviceUrl = "dataCollections";
        HashMap headers = new HashMap();
        DataCollection dc = new DataCollection();
        dc.setEndDate(new Date(openTo));
        dc.setLabel(label);
        dc.setStartDate(new Date(openFrom));
        dc.setStatus(Integer.valueOf(0));
        DataModel dm = new DataModel();
        dm.setId(Integer.valueOf(dataModelId));
        dc.setDataModel(dm);
        Domain d = new Domain();
        d.setLabel(scope);
        dc.setDomain(d);
        dc.setCreateUser(new UserReference(username));
        Response clientResponse = this.singletonHttpClient.doPost(serviceUrl, headers, (Object)dc);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        String result = (String)clientResponse.readEntity(String.class);
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        } else {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)result);
        }
    }

    @ResourceMapping(value="updateDataCollection")
    public void updateDataCollection(ResourceRequest request, ResourceResponse response) throws IOException {
        _log.debug((Object)"Adding data collection");
        String label = ParamUtil.getString((PortletRequest)request, (String)"label");
        long openFrom = ParamUtil.getLong((PortletRequest)request, (String)"openFrom");
        long openTo = ParamUtil.getLong((PortletRequest)request, (String)"openTo");
        int dataModelId = ParamUtil.getInteger((PortletRequest)request, (String)"dataModelId");
        int dataCollectionId = ParamUtil.getInteger((PortletRequest)request, (String)"dataCollectionId");
        String serviceUrl = "dataCollections/" + dataCollectionId;
        HashMap headers = new HashMap();
        DataCollection dc = new DataCollection();
        dc.setEndDate(new Date(openTo));
        dc.setLabel(label);
        dc.setStartDate(new Date(openFrom));
        dc.setStatus(Integer.valueOf(0));
        DataModel dm = new DataModel();
        dm.setId(Integer.valueOf(dataModelId));
        dc.setDataModel(dm);
        Domain d = new Domain();
        d.setLabel(scope);
        dc.setDomain(d);
        dc.setUpdateUser(new UserReference(username));
        Response clientResponse = this.singletonHttpClient.doPost(serviceUrl, headers, (Object)dc);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        String result = (String)clientResponse.readEntity(String.class);
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        } else {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)result);
        }
    }

    @ResourceMapping(value="deleteDataCollection")
    public void deleteDataCollection(ResourceRequest request, ResourceResponse response) throws IOException {
        _log.debug((Object)"Deleting data collection");
        long id = ParamUtil.getLong((PortletRequest)request, (String)"id");
        String serviceUrl = "dataCollections/" + id;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        Response clientResponse = this.singletonHttpClient.doDelete(serviceUrl, headers);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        String result = (String)clientResponse.readEntity(String.class);
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        stateObject.put("result", result);
        if (status == HttpStatus.NO_CONTENT.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)HttpStatus.NO_CONTENT.value(), (Object)stateObject);
        } else if (status == HttpStatus.NOT_FOUND.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.NOT_FOUND.value(), (Object)result);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        }
    }
}

