(function() {
	'use strict';
	var appUsers = {
			appUsersContainer : null,
			
			appUsersModal : null,
			
		    clearMessage : function() {
		    	window.notificator.clearMessage(appUsers.notificator);
		    },
			
			createDataTable : function() {
				$('.regional-data-collection-data-collection-datatable').PortletDataTable({
					ajax : {
				        url : window.config.createResourceURL('getAllVreUsers'),
				        type : 'get',
				        cache : false,
				        dataType : "json",
				        beforeSend : function(xhr) { },
				        dataSrc : function(data) {
				        	var data = $.parseJSON(data.result);
				        	
				        	return data;
				        },
				        error : function(jqXHR, exception) {
				        	appUsers.errorHandling(jqXHR, exception);
				        },
				        complete : function() {

				        },
				        timeout : 20000
					},
					columnDefs : [{
						title : "Username",
						fieldName : 'label',
						targets : 0
					},{
			        	title : "Full Name",
			        	fieldName : "fullName",
			            targets : 1
			        }, {
			        	title : "email",
			        	fieldName : "email",
			        	targets : 2
			        }, {
			        	title : "Attributes",
			            fieldName : "attributes",
			            targets :  3,
			        }],
			        order : [[0, "asc"]],
			    	toolbar : $('.regional-data-collection-app-users-toolbar')
				});
			    
			    // Get Widget Instance
			    this.dataTable = $('.regional-data-collection-data-collection-datatable').data("dt-PortletDataTable");
			},

			createUserAndDomainIfNotExist( $callbacks ) {
			    var self = this;

			    var bSC = function() {
			        $callbacks.showAppSpinner();
			    };

                var oSC = function(data) {
                    $callbacks.enableDataColelctionTab();
                };

                var oEC = function(jqXHR, textStatus, errorThrown) {
                    $callbacks.onErrorCallback(jqXHR, textStatus, errorThrown);
                };

                var oCC = function() {
                    $callbacks.removeAppSpinner();
                };

                window.ajaxCalls.post( 'createUserAndDomainIfNotExist', {}, bSC, oSC, oEC, oCC );
			},
			
			init: function( $tab, $container, $callbacks ) {
			    this.createUserAndDomainIfNotExist( $callbacks );

				$tab.one('click', function() {
					appUsers.appUsersContainer = $container;
					appUsers.loadContent($tab);
					appUsers.loadCSS();
				});
			},
			
			initEditUserWidget : function(){
				var modalButtons = [];
				var buttonProps = {
						dismissModal : true,
						label : 'Save',
						className : 'save-button',
						disabled : true,
						handler : function() {
							var data = {};
							data.dataModelId = $('#regional-data-collection-data-collection-add-form-schema-version').val();
							var label = $('#regional-data-collection-data-collection-add-form-label').val();
							data.label = label;
							data.openFrom = new Date($('#regional-data-collection-data-collection-add-form-open-from-date').val()).getTime().toString();
							data.openTo = new Date($('#regional-data-collection-data-collection-add-form-open-to-date').val()).getTime();
							
							var bSC = undefined;
							var oSC = function() {
								var callback = function() {
									appUsers.showMessage('Data collection <b>' + label + '</b> was added successfully', "success");
								};
								appUsers.reloadData(callback);
							};
							var oEC = function(jqXHR, textStatus, errorThrown) { appUsers.errorHandling(jqXHR, errorThrown); };
							
							window.ajaxCalls.post('addDataCollection', data, bSC, oSC, oEC, null);
						}
				};
				modalButtons.push(buttonProps);
				
				var editUserModal = appUsers.appUsersModal.ModalWidget({
					ajaxCall : window.ajaxCalls,
					config : window.config,
					modalHeaderText : 'Edit user',
					modalButtons : [],
					widgetName : 'EditAppUserEditor',
					modalWidgetOptions : {
						appUsers : appUsers,
						ajaxCalls : window.ajaxCalls,
						config : window.config,
						setButtonVisibility : function(name, visible) {
							editUserModal.ModalWidget('setButtonVisibility', name, visible);
						}
					}
				});
			},
			
			initUIBinding : function() {
				this.appUsersContainer.find('#regional-data-collection-app-users-view-button').off().on('click', function() {
					appUsers.initEditUserWidget();
				});
			},
			
			getΑppUsers : function() {
				this.createDataTable();
			},
			
			 errorHandling : function(jqXHR, exception) {
				 window.notificator.errorHandling(appUsers.notificator, jqXHR, exception);
			 },
			
			loadContent : function($tab) {
				let $spinner =  window.config.getLoadContentSpinner();
				$spinner.insertBefore(this.appUsersContainer);
				this.appUsersContainer.load(window.config.contextPath + "modules/app-user/app-user.jsp", function() {
					$spinner.remove();
					appUsers.notificator = $('#regional-data-collection-app-users-notificator');
					appUsers.appUsersModal = $('.app-users-modal');
					appUsers.initUIBinding();
					appUsers.getΑppUsers();

                    $tab.on('shown', function() {
                        appUsers.reloadData(function() {});
                    });
				});
			},
			
			loadCSS : function() {
				$("<link/>", {
			        rel : "stylesheet",
			        type : "text/css",
			        href : window.config.contextPath + "modules/app-user/app-user-edit-app-user-editor/edit-app-user-editor-widget.css"
			    }).appendTo("head");
			},
			
			reloadData : function(callback) {
				if(typeof callback === 'undefined') {
					appUsers.dataTable.refreshData(appUsers.clearMessage);
				} else {
					appUsers.dataTable.refreshData(callback);
				}

			},
			
			notificator : null,
			
		    showMessage : function(text, type) {
			    window.notificator.setText(appUsers.notificator, text, type);
		    },
	};
	
	window.appUsers = appUsers;
})();