(function (){
	'use strict';
	
	var config = {
	    appNotificator : null,
	    appSpinner : null,
		constants : {
			loadContentSpinnerClassName : 'fa fa-spinner fa-spin fa-3x fa-fw',
			pageSpinnerClassName : 'spinner',
//			inlineSpinnerClassName : 'regional-data-collection-loaders'
			inlineSpinnerClassName : 'fa fa-spinner fa-spin fa-2x fa-fw'
		},
		contextPath : null,
		dateMinValue : new Date(-8640000000000000),
		dateIn_yyy_MM_dd_format : function(date) {
		    var d = new Date(date),
	        month = '' + (d.getMonth() + 1),
	        day = '' + d.getDate(),
	        year = d.getFullYear();

		    if (month.length < 2) month = '0' + month;
		    if (day.length < 2) day = '0' + day;
	
		    return [year, month, day].join('-');
		},
		dateOptions : { 
				year: 'numeric',
				month: 'short',
				day: 'numeric',
				hour: 'numeric',
				minute: 'numeric',
				hour12: false
		},
	    formatDate : function(dateStr) {
	    	var date = this.getLocalDateString(dateStr);
	    	var firstHalf = date.substring(0, date.indexOf(','));
	    	
//	    	var secondHalf = date.substring(date.indexOf(','), date.length);
	    	
	    	firstHalf = firstHalf.replace(/ /g,'-');
	    	
//	    	return firstHalf + secondHalf;
	    	return firstHalf;
	    },
	    getLocalDateString : function(date) {
	    	return new Date(date).toLocaleString(config.locale, config.dateOptions);
	    },
//	    https://stackoverflow.com/questions/1349404/generate-random-string-characters-in-javascript
	    generateId : function() {
	    	var id = "";
	    	var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

	    	for (var i = 0; i < 5; i++)
	    		id += possible.charAt(Math.floor(Math.random() * possible.length));

	    	return id;
	    },
		locale : null,
		modalContainer : null,
		nameSpace : null,
		resourceURL : null,
		renderURL 	: null,
		init : function(args) {
		    var self = this;
		    this.appNotificator = args.appNotificator;
		    this.appSpinner = args.appSpinner;
			this.contextPath = args.contextPath;
			this.locale = args.locale.replace("_","-");
			this.modalContainer = args.modalContainer;
			this.nameSpace = args.nameSpace;
			this.resourceURL = args.resourceURL;
			this.resourceURLNoParams = args.resourceURLNoParams;
			this.renderURL = args.renderURL;
			this.username = args.username;
			this.widgetContainer = args.widgetContainer;
			
			$.getScript(window.config.contextPath + "modules/base-widget/base-widget.js").done(function(){
				$.getScript(window.config.contextPath + "modules/modal-widget/modal-widget.js").done(function(){
					window.ajaxCalls.setNamespace(config.nameSpace);
					window.dataSubmission.init($('.regional-data-collection-data-submission a[data-toggle="tab"]'), $('#regional-data-collection-data-submissions-container'));

					let spinner = config.getLoadContentSpinner();

                    let showAppSpinner = function() {
                        self.appSpinner.prepend( spinner );
                    };

					let enableDataColelctionTab = function() {
                        $('.tabbable.navbarTop').removeClass('hidden');
                        setTimeout(function() {
                            window.dataCollection.init($('.regional-data-collection-data-collection a'), $('#regional-data-collection-data-collections-container'));
                        }, 100);
					};

                    let removeAppSpinner = function() {
                        spinner.remove();
                    };

                    let onErrorCallback = function(jqXHR, textStatus, errorThrown) {
                        window.notificator.errorHandling( self.appNotificator, jqXHR, errorThrown );
                    };

                    let $callbacks = {};
                    $callbacks.showAppSpinner = showAppSpinner;
                    $callbacks.enableDataColelctionTab = enableDataColelctionTab;
                    $callbacks.removeAppSpinner = removeAppSpinner;
                    $callbacks.onErrorCallback = onErrorCallback;

					window.dataModel.init($('.regional-data-collection-data-model a'), $('#regional-data-collection-data-models-container'));
					window.appUsers.init($('.regional-data-collection-app-users a[data-toggle="tab"]'), $('#regional-data-collection-app-users-container'), $callbacks);
				});
			});
		},
		createResourceURL : function(resourceId, parameters){
			if(parameters == undefined || parameters == null){
				return this.resourceURLNoParams.replace('%7Burl%7D', resourceId);
			} else {
				var resourceURL = this.resourceURL.replace('%7Burl%7D', resourceId);
				return resourceURL.replace('%7Bparameters%7D', parameters);
			}
		},
        createResourceUrlWithParameters : function(resourceId, parameters) {
            var resourceURL = this.resourceURL.replace('%7Burl%7D', resourceId);
            var parametersString = "";

            var firstParameter = true;

            for ( var property in parameters) {
                if (parameters.hasOwnProperty(property)) {
                    if (firstParameter) {
                        firstParameter = false;
                        parametersString += "?"
                    } else {
                        parametersString += "&"
                    }
                    parametersString += property + "=" + parameters[property];
                }
            }

            return resourceURL.replace('%3F%7Bparameters%7D', parametersString);		    
		},
		getInlineSpinner : function() {
			return this.inlineSpinner().clone();
		},
		getLoadContentSpinner : function() {
			return this.loadContentSpinner().clone();
		},
		getPageSpinner : function() {
			return this.pageSpinner().clone();
		},
		showPageSpinner : function($element) {
			$element.find("." + this.constants.pageSpinnerClassName).show();
		},
		showModalLoaders : function() {
			$('.' + this.constants.inlineSpinnerClassName).show();
		},
		pageSpinner : function() {
			var self = this;
			var pageSpinner = $('<i></i>', {
				class : self.constants.pageSpinnerClassName
			});
			
			return pageSpinner;
		},
		inlineSpinner : function() {
			var self = this;
			var inlineSpinner = $('<span></span>', {
				class : self.constants.inlineSpinnerClassName
			});
			
			return inlineSpinner;
		},
		loadContentSpinner : function() {
			var self = this;
			var loadContentSpinner = $('<span></span>', {
				class : self.constants.loadContentSpinnerClassName,
				css : {
				    'margin-left' : '48%'
				}
			});
			
			return loadContentSpinner;
		},
		hideSpinner : function(){
			$(".spinner").hide();
		},
		hideModalLoaders : function() {
			$('.regional-data-collection-loaders').hide();
		},
		username : null,
		widgetContainer : null
	}	

	window.config = config;	
})();