$.widget('rdb.DataCollectionEditModal', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		config : null,
		dataCollection : null,
		schemaVersionLoaderContainer : 'regional-data-collection-data-collection-edit-form-schema-version-loader-container',
		setButtonVisibility : null,
		url : null
	},
	
	_create : function() {
		var self = this;
		this.options.url = 'modules/data-collection/data-collection-edit-datacollection-editor-widget/data-collection-edit-datacollection-editor-widget.jsp';
		this.options.callback = function() {
			self.initUIBindings();
			self.initValidation();
		};
		if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
		    console.log('DataCollectionEditModal');
		
		this._super();
	},
	
	_destroy : function() {
		this.element.html('');
	},
	
	initUIBindings : function() {
		var self = this;
		
//		Fill dropdown with options
		setTimeout(function() {
			var bSC = function() {
				if(self.schemaVersionLoader === null) {
					self.schemaVersionLoader = config.getInlineSpinner();
					self.schemaVersionLoader.appendTo(self.element.find('.'+self.options.schemaVersionLoaderContainer));
				} else self.schemaVersionLoader.show();
			};
			
			var oSC = function(data) {
				$('#regional-data-collection-data-collection-edit-form-schema-version').html('');
				
				var dataModels = $.parseJSON($.parseJSON(data).result);
				
				$.each(dataModels, function(i,v) {
					$('<option></option>', {
						text : v.label + ' - ' + v.version,
						value : v.id
					})
					.appendTo($('#regional-data-collection-data-collection-edit-form-schema-version'));
				});
				
				$('#regional-data-collection-data-collection-edit-form-schema-version').val(self.options.dataCollection.dataTable.getSelectedRowData().dataModel.id);
				
				var data = dataCollection.dataTable.getSelectedRowData();
				
				$('#regional-data-collection-data-collection-edit-form-label').val(data.label);
				$('#regional-data-collection-data-collection-edit-form-open-from-date').val(window.config.dateIn_yyy_MM_dd_format(data.startDateObject));
				$('#regional-data-collection-data-collection-edit-form-open-to-date').val(window.config.dateIn_yyy_MM_dd_format(data.endDateObject));
				$('#regional-data-collection-data-collection-edit-form-schema-version').prop('disabled', !data.canChangeDataModel );
				
				self.validateEditDataCollectionForm();
			};
			
			var oEC = function(jqXHR, textStatus, errorThrown) {
				$('#regional-data-collection-data-collection-edit-modal').modal('hide');
				self.options.dataCollection.errorHandling(jqXHR, errorThrown);
			};
			
			var oCC = function() {
				self.schemaVersionLoader.hide();
			};
			
			self.options.ajaxCalls.get('getAllDataModels', bSC, oSC, oEC, oCC);
		}, 300);
		
	},
	
	initValidation : function() {
		var self = this;
		
		jQuery.validator.addMethod("fromToDateLesserThanToDateInEditDataCollectionForm", function(value, element) {
			var dateFromStr = $(element).val();
			var dateToStr = $('#regional-data-collection-data-collection-edit-form-open-to-date').val();
			if(dateToStr.length === 0) return true;
			else return new Date(dateFromStr) < new Date(dateToStr);
		}, "Must be lesser than the Open to date");
		
		jQuery.validator.addMethod("toDateLesserThanFromDateInEditDataCollectionForm", function(value, element) {
			var dateToStr = $(element).val();
			var dateFromStr = $('#regional-data-collection-data-collection-edit-form-open-from-date').val();
			if(dateFromStr.length === 0) return true;
			else return new Date(dateFromStr) < new Date(dateToStr);
		}, "Must be greater than the Open from date");

		this.validator = this.element.find('#regional-data-collection-data-model-edit-form').validate({
	        onkeyup: function (element, event) {
	            if (event.which === 9 && this.elementValue(element) === "") {
	                return;
	            } else {
	                this.element(element);
	            }
	            
	            var valid = $(event.target).closest("form").validate().checkForm();
	            if(self.options.setButtonVisibility !== null)
					self.options.setButtonVisibility('save-button', valid);
	        },
	        onfocusout : function (element, event) {
	            if (event.which === 9 && this.elementValue(element) === "") {
	                return;
	            } else {
	                this.element(element);
	            }
	        },
			rules : {
				'regional-data-collection-data-collection-edit-form-label' : {
					required : true
				},
				
				'regional-data-collection-data-collection-edit-form-open-from-date' : {
					required : true,
					date : true,
					fromToDateLesserThanToDateInEditDataCollectionForm : true
				},
				
				'regional-data-collection-data-collection-edit-form-open-to-date' : {
					required : true,
					date : true,
					toDateLesserThanFromDateInEditDataCollectionForm : true
				}
			},
		    highlight : function(element) {
		    	$(element).closest('.control-group').addClass('error');
		    },
		    success : function(label, element) {
			    $(element).closest('.control-group').removeClass('error');
			    label.remove();
		    },
		    errorPlacement : function(error, element) {
		    	error.css('color', 'red');
		    	error.appendTo( element.closest('.controls') );
		    }
		});
		
		this.element.find('#regional-data-collection-data-collection-edit-form-open-from-date').on('change', function() {
			self.validator.element($(this));
		});
		
		this.element.find('#regional-data-collection-data-collection-edit-form-open-to-date').on('change', function() {
			self.validator.element($(this));
		});
		
		this.element.find('#regional-data-collection-data-model-edit-form input[type=date]')
		.on('change', function() {
			$(this).closest("form").validate().element(this);
			
			self.element.find('#regional-data-collection-data-model-edit-form input[type=date]').each(function(index, value) {
				if($(this).val() !== '')
					$(this).closest("form").validate().element(this);
			});
			
			var valid = $(this).closest("form").validate().checkForm();
			if(self.options.setButtonVisibility !== null)
				self.options.setButtonVisibility('save-button', valid);
		});
	},
	
	schemaVersionLoader : null,
	
	validateEditDataCollectionForm : function() {
		this.element.find('#regional-data-collection-data-model-edit-form').validate().form();
	},
	
	validator : null
});